% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.data}
\alias{read.data}
\alias{read.data.default}
\alias{read.data.matrix}
\title{Read geochronology data}
\usage{
read.data(x, ...)

\method{read.data}{default}(x, method = "U-Pb", format = 1, ...)

\method{read.data}{matrix}(x, method = "U-Pb", format = 1, ...)
}
\arguments{
\item{x}{a file name (\code{.csv} format) or matrix}

\item{...}{optional arguments to the \code{read.csv} function}

\item{method}{one of \code{'U-Pb'}, \code{'Ar-Ar'},
\code{'detritals'} \code{'U-Th-He'}, \code{'fissiontracks'} or
\code{'other'}}

\item{format}{formatting option, depends on the value of
    \code{method}.

- if \code{method = 'Ar-Ar'}, then \code{format} is one of either:

\enumerate{
\item{\code{39/40, s[39/40], 36/40, s[36/40], 39/36, s[39/36]}}
\item{\code{39, 39/40, s[39/40], 36/40, s[36/40], 39/36, s[39/36]}}
}

- if \code{method = 'fissiontracks'}, then \code{format} is
one of either:

\enumerate{
\item{the External Detector Method (EDM), which requires a
\eqn{\zeta}-calibration constant and its uncertainty, the induced
track density in a dosimeter glass, and a table with the
spontaneous and induced track densities.}

\item{LA-ICP-MS-based fission track data using the
\eqn{\zeta}-calibration method, which requires a 'session
\eqn{\zeta}' and its uncertainty and a table with the number of
spontaneous tracks, the area over which these were counted and one
or more U/Ca- or U-concentration measurements and their analytical
uncertainties.}

\item{LA-ICP-MS-based fission track data using the 'absolute
dating' method, which only requires a table with the the number of
spontaneous tracks, the area over which these were counted and one
or more U/Ca- or U-concentration measurements and their analytical
uncertainties.}
}}
}
\value{
an object of class \code{UPb}, \code{ArAr}, \code{UThHe},
    \code{detritals} \code{fissiontracks} or \code{other}
}
\description{
Cast a \code{.csv} file or a matrix into one of \code{IsoplotR}'s
data classes
}
\examples{
# load one of the built-in .csv files:
data(examples)
concordia(examples$UPb)
}

