% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helioplot.R
\name{central}
\alias{central}
\alias{central.UThHe}
\alias{central.default}
\title{Calculate U-Th-He (and fission track) central ages and compositions}
\usage{
central(x, ...)

\method{central}{default}(x, ...)

\method{central}{UThHe}(x, ...)
}
\arguments{
\item{x}{an object of class \code{UThHe} or \code{fissiontracks}}

\item{...}{optional arguments}
}
\value{
if \code{x} has class \code{UThHe}, retuns a list
    containing the following items:

\code{uvw} (if the input data table contains Sm) or \code{uv} (if it doesn't):
the geometric mean log[U/He], log[Th/He] (, log[Sm/He]) and log[Sm/He]
composition

\code{covmat}: the covariance matrix of \code{uvw} or \code{uv}

\code{mswd}: the reduced Chi-square statistic of data concordance,
i.e. mswd = SS/(2n-2) where SS is the sum of squares of the
log[U/He]-log[Th/He] compositions and n is the number of samples.

\code{p.value}: the p-value of a Chi-square test with n-2 degrees
of freedom

\code{age}: a two-column vector with the central age and its
standard error.
}
\description{
Computes the geometric mean composition of a set of fission track
or U-Th-He data and returns the corresponding age and fitting
parameters.
}
\examples{
data(examples)
print(central(examples$UThHe)$age)
}

