% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_interaction.R
\name{generate_interaction}
\alias{generate_interaction}
\title{Generate interaction data set}
\usage{
generate_interaction(
  N,
  r.x1.y,
  r.x2.y,
  r.x1x2.y,
  r.x1.x2,
  rel.x1 = 1,
  rel.x2 = 1,
  rel.y = 1,
  skew.x1 = 0,
  skew.x2 = 0,
  skew.y = 0,
  k.x1 = 0,
  k.x2 = 0,
  k.y = 0,
  transform.x1 = "default",
  transform.x2 = "default",
  transform.y = "default",
  adjust.correlations = TRUE,
  r.x1.y.adjust = NULL,
  r.x2.y.adjust = NULL,
  r.x1x2.y.adjust = NULL,
  r.x1.x2.adjust = NULL,
  tol = 0.005,
  iter = 10
)
}
\arguments{
\item{N}{Sample size. Must be a positive integer. Has no default value.}

\item{r.x1.y}{Pearson's correlation between x1 and y. Must be between -1 and 1. Has no default value.}

\item{r.x2.y}{Pearson's correlation between x2 and y. Must be between -1 and 1. Assumed to be the 'moderator' in some functions. Has no default value.}

\item{r.x1x2.y}{Pearson's correlation between the interaction term x1x2 (x1 * x2) and y. Must be between -1 and 1. Has no default value.}

\item{r.x1.x2}{Pearson's correlation between x1 and x2. Must be between -1 and 1. Has no default value.}

\item{rel.x1}{Reliability of x1 (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{rel.x2}{Reliability of x2 (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{rel.y}{Reliability of xy (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{skew.x1}{Skew of x1. Default is 0 (normally distributed).}

\item{skew.x2}{Skew of x2. Default is 0 (normally distributed).}

\item{skew.y}{Skew of y. Default is 0 (normally distributed).}

\item{k.x1}{Number of discrete values for x1. k.x1 = 2 is equivalent to transform.x1 = "binary". Performs best with k<= 5 if variable is skewed. Otherwise, up to k=20. Values less than 2 result in a continuous variable.}

\item{k.x2}{Number of discrete values for x2. k.x2 = 2 is equivalent to transform.x2 = "binary". Performs best with k<= 5 if variable is skewed. Otherwise, up to k=20. Values less than 2 result in a continuous variable.}

\item{k.y}{Number of discrete values for y. k.y = 2 is equivalent to transform.y = "binary". Performs best with k<= 5 if variable is skewed. Otherwise, up to k=20. Values less than 2 result in a continuous variable.}

\item{transform.x1}{Transform x1? Options are "default", "binary", or "gamma". "binary" will cause variable to be binarized  - 2 unique values. Default ("default") will pick "gamma" if variable is skewed.}

\item{transform.x2}{Transform x2? Options are "default", "binary", or "gamma". "binary" will cause variable to be binarized  - 2 unique values. Default ("default") will pick "gamma" if variable is skewed.}

\item{transform.y}{Transform y? Options are "default", "binary", or "gamma". "binary" will cause variable to be binarized  - 2 unique values. Default ("default") will pick "gamma"if variable is skewed.}

\item{adjust.correlations}{If variables are skewed or binary, should correlations be adjusted so that output data has the specified correlation structure? Default is TRUE.}

\item{r.x1.y.adjust}{Internal use only}

\item{r.x2.y.adjust}{Internal use only}

\item{r.x1x2.y.adjust}{Internal use only}

\item{r.x1.x2.adjust}{Internal use only}

\item{tol}{Correlation adjustment tolerance. When adjust.correlations = TRUE, correlations are adjusted so that the population correlation is within r='tol' of the target. Default = 0.005.}

\item{iter}{Max number of iterations to run the correlation adjustment for. Typically only a couple are needed. Default = 10.}
}
\value{
A data frame containing variables 'x1', 'x2', 'y', and 'x1x2'. 'x1x2' is x1*x2. The correlations between these variables are drawn from the defined population-level values.
}
\description{
Simulate a single data set with an interaction (y ~ x1 + x2 + x1*x2). All values other than 'N' are population-level effects - the values within any single simulated data set will vary around the defined values.
}
\examples{
dataset <- generate_interaction(N = 10,r.x1.y = 0,r.x2.y = .1,r.x1x2.y = -.2,r.x1.x2 = .3)
}
