% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/InterVA.plot.R
\name{Population.summary}
\alias{Population.summary}
\title{Summarize and plot a population level distribution of va probabilities.}
\usage{
Population.summary(va, top.aggregate = NULL, InterVA.rule = FALSE,
  noplot = FALSE, type = "bar", min.prob = 0.01, ...)
}
\arguments{
\item{va}{The list of va object to summarize.}

\item{top.aggregate}{Integer indicating how many causes from the top need to go into
summary. The rest of the probabilities goes into an extra category
"Undetermined".  When set to NULL, default is all causes to be considered.
This is only used when \code{InterVA.rule} set to "FALSE".}

\item{InterVA.rule}{If it is set to "TRUE", only the top 3 causes reported by
InterVA4 is calculated into CSMF as in InterVA4. The rest of probabilities
goes into an extra category "Undetermined". Default set to "FALSE".}

\item{noplot}{A logical value indicating whether the plot will be shown. If
it is set to "TRUE", only the CSMF will be returned.}

\item{type}{An indicator of the type of chart to plot.  "pie" for pie chart;
"bar" for bar chart.}

\item{min.prob}{The minimum probability that is to be plotted in bar chart,
or to be labeled in pie chart.}

\item{...}{Arguments to be passed to/from graphic function
\code{\link[graphics]{barplot}}, \code{\link[graphics]{pie}}, and more
graphical paramters (see \code{\link[graphics]{par}}). They will affect the
main title, size and font of labels, and the radius of the pie chart.}
}
\value{
\item{dist.cod}{The population probability of CODs.}
}
\description{
This function has been deprecated as of version 1.6. Use 'CSMF' instead.
}
\author{
Zehang LI, Tyler McCormick, Sam Clark
}
\seealso{
\code{\link{CSMF.interVA4}}
}
\keyword{interVA}

