% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{TrackCluster}
\alias{TrackCluster}
\title{Follow a cluster over multiple methods}
\usage{
TrackCluster(List, Selection, nrclusters = NULL, followMaxComps = FALSE,
  followClust = TRUE, fusionsLog = TRUE, weightclust = TRUE,
  names = NULL, selectionPlot = FALSE, table = FALSE,
  completeSelectionPlot = FALSE, ClusterPlot = FALSE, cols = NULL,
  legendposx = 0.5, legendposy = 2.4, plottype = "sweave",
  location = NULL)
}
\arguments{
\item{List}{A list of the clustering outputs.The first element of the list
will be used as the reference in \code{ReorderToReference}.}

\item{Selection}{The selection of objects to follow or a specific cluster
number. Default is NULL.}

\item{nrclusters}{The number of clusters to cut the dendrogram in. Default is NULL.}

\item{followMaxComps}{Logical for plot. Whether to follow the maximum of
objects. Default is FALSE.}

\item{followClust}{Logical for plot. Whether to follow the specific cluster. Default is TRUE.}

\item{fusionsLog}{Logical. To be handed to \code{ReorderToReference}: indicator for the fusion of clusters. Default is TRUE}

\item{weightclust}{Logical. To be handed to \code{ReorderToReference}: to be used for the outputs of CEC,
WeightedClust or WeightedSimClust. If TRUE, only the result of the Clust element is considered. Default is TRUE.}

\item{names}{Optional. Names of the methods. Default is NULL.}

\item{selectionPlot}{Logical. Should a plot be produced. Depending on
followMaxComps and followClust it focuses on the maximum of objects or a
cluster. It will not be indicated to which cluster objects moved. Default is FALSE.}

\item{table}{Logical. Should a table with the objects per method and the
shared objects be produced? Default is FALSE.}

\item{completeSelectionPlot}{Logical. Should the complete distribution of
the selection be plotted? This implies that it will be indicated to which
cluster objects will move. Default is FALSE.}

\item{ClusterPlot}{Logical. Plot of specific cluster. Default is FALSE.}

\item{cols}{The colors used for the different clusters. Default is NULL.}

\item{legendposx}{The x-coordinate of the legend on all plots. Default is 0.5.}

\item{legendposy}{The y-coordinate of the legend on all plots. Default is 2.4.}

\item{plottype}{Should be one of "pdf","new" or "sweave". If "pdf", a
location should be provided in "location" and the figure is saved there. If
"new" a new graphic device is opened and if "sweave", the figure is made
compatible to appear in a sweave or knitr document. Default is "new".}

\item{location}{If plottype is "pdf", a location should be provided in
"location" and the figure is saved there. Default is NULL.}
}
\value{
The returned value is a list with an element for every method. This
element is another list with the following elements: \item{Selection}{The
selection of objects to follow} \item{nr.clusters}{the number of clusters
the selection is divided over} \item{nr.min.max.together }{the minimum and
maximum number of objects found together}
\item{perc.min.max.together}{minimum and maximum percentage of objects
found together} \item{AllClusters}{A list with an element per cluster that
contains at least one of the objects in Selection. The list contains the
cluster number, the complete cluster, the objects that originally could be
found in this cluster and which object were joined extra to it.} Depending
on whether followMaxComps or followClust is specified, the cluster of
interest is mentioned separately as well for easy access. If the option was
specified to create a table, this can be found under the Table element. Each
plot that was specified to be created is plotted in a new window in the
graphics console.
}
\description{
It is often desired to track a specific selection of object over the
different methods and/or weights. This can be done with the
\code{ClusterDistribution}. For every method, it is tracked where the
objects of the selections are situated.
}
\details{
The result is provided with extra information as which objects of the
original selection can be found in this cluster and which are extra.
Further, plots of the distribution of the objects can be produced.  One
plot follows the complete distribution of the cluster while another one
focuses on either the maximum number of objects or a specific cluster,
whatever is specified. It are the number of objects that are plotted and
the first element indicated the number of objects in the selection. A
table can be produced as well, that separates the objects that are shared
over all methods from those extra in the original selection and extra for
the other methods. The \code{ReorderToReference} is applied to make sure
that the clusters are comparable over the methods.

The function is experimental and might not work in specific cases. Please
let us know such that we can improve its functionality.
}
\examples{
\dontrun{
data(fingerprintMat)
data(targetMat)
data(Colors1)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

L=list(MCF7_F,MCF7_T)
names=c("FP","TP")

Comps=FindCluster(List=L,nrclusters=7,select=c(1,4))
Comps

CompsFPAll=TrackCluster(List=L,Selection=Comps,nrclusters=7,followMaxComps=TRUE,
followClust=FALSE,fusionsLog=TRUE,weightclust=TRUE,names=names,selectionPlot=TRUE,
table=TRUE,completeSelectionPlot=TRUE,cols=Colors1,plottype="new",location=NULL)
}

}
