% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{DiffGenes}
\alias{DiffGenes}
\title{Differential gene expressions for multiple results}
\usage{
DiffGenes(List, Selection = NULL, geneExpr = NULL, nrclusters = NULL,
  method = "limma", sign = 0.05, topG = NULL, fusionsLog = TRUE,
  weightclust = TRUE, names = NULL)
}
\arguments{
\item{List}{A list of the clustering outputs to be compared. The first
element of the list will be used as the reference in
\code{ReorderToReference}.}

\item{Selection}{If differential gene expression should be investigated for
a specific selection of objects, this selection can be provided here.
Selection can be of the type "character" (names of the objects) or
"numeric" (the number of specific cluster). Default is NULL.}

\item{geneExpr}{The gene expression matrix or ExpressionSet of the objects.
The rows should correspond with the genes.}

\item{nrclusters}{Optional. The number of clusters to cut the dendrogram in.
The number of clusters should not be specified if the interest lies only in
a specific selection of objects which is known by name.  Otherwise, it is
required. Default is NULL.}

\item{method}{The method to applied to look for DE genes. For now, only the
limma method is available. Default is "limma".}

\item{sign}{The significance level to be handled. Default is 0.05.}

\item{topG}{Overrules sign. The number of top genes to be shown. Default is NULL.}

\item{fusionsLog}{Logical. To be handed to \code{ReorderToReference}: indicator for the fusion of clusters. Default is TRUE}

\item{weightclust}{Logical. To be handed to \code{ReorderToReference}: to be used for the outputs of CEC,
WeightedClust or WeightedSimClust. If TRUE, only the result of the Clust element is considered. Default is TRUE.}

\item{names}{Optional. Names of the methods. Default is NULL.}
}
\value{
The returned value is a list with an element per method. Each
element contains a list per cluster with the following elements:
\item{objects}{A list with the elements LeadCpds (the objects of
interest) and OrderedCpds (all objects in the order of the clustering
result)} \item{Genes}{A list with the elements TopDE (a table with
information on the top genes) and AllDE (a table with information on all
genes)}
}
\description{
The function \code{DiffGenes} will, given the output of a certain method,
look for genes that are differentially expressed for each cluster by
applying the limma function to that cluster and compare it to all other
clusters simultaneously. If a list of outputs of several methods is
provided, DiffGenes will perform the limma function for each method.
}
\details{
The function rearranges the clusters of the methods to a reference method
such that a comparison is made easier.  Given a list of methods, it calls
upon \code{ReorderToReference} to rearrange the number of clusters according
to the first element of the list which will be used as the reference.
}
\examples{

data(fingerprintMat)
data(targetMat)
data(geneMat)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

L=list(MCF7_T ,MCF7_F)

MCF7_FT_DE = DiffGenes(List=L,geneExpr=geneMat,nrclusters=7,method="limma",
sign=0.05,topG=10,fusionsLog=TRUE,weightclust=TRUE)
}
\references{
SMYTH, G. K. (2004). Linear models and empirical Bayes methods
for assessing differential expression in microarray experiments. Statistical
Applications in Genetics and Molecular Biology. 3(1).
}
