% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{CEC}
\alias{CEC}
\title{Complementary ensemble clustering}
\usage{
CEC(List, distmeasure = c("tanimoto", "tanimoto"), normalize = c(FALSE,
  FALSE), method = c(NULL, NULL), t = 10, r = NULL, nrclusters = NULL,
  weight = NULL, clust = "agnes", linkage = c("flexible", "flexible"),
  alpha = 0.625, weightclust = 0.5)
}
\arguments{
\item{List}{A list of data matrices. It is assumed the rows are corresponding with the objects.}

\item{distmeasure}{A vector of the distance measures to be used on each data matrix. Should be one of "tanimoto", "euclidean", "jaccard", "hamming". Defaults to c("tanimoto","tanimoto").}

\item{normalize}{Logical. Indicates whether to normalize the distance matrices or not, defaults to c(FALSE, FALSE) for two data sets. This is recommended if different distance types are used. More details on normalization in \code{Normalization}.}

\item{method}{A method of normalization. Should be one of "Quantile","Fisher-Yates", "standardize","Range" or any of the first letters of these names. Default is c(NULL,NULL) for two data sets.}

\item{t}{The number of iterations. Defaults to 10.}

\item{r}{A vector with the number of features to take for the random sample for each element in List. If NULL (default), all features are considered.}

\item{nrclusters}{A list with a sequence of numbers of clusters to cut the dendrogram in for each element in List. If NULL (default), the function stops.}

\item{weight}{The weights for the weighted linear combination.}

\item{clust}{Choice of clustering function (character). Defaults to "agnes".}

\item{linkage}{Choice of inter group dissimilarity (character) for each data set. Defaults to c("flexible", "flexible") for two data sets.}

\item{alpha}{The parameter alpha to be used in the "flexible" linkage of the agnes function. Defaults to 0.625 and is only used if the linkage is set to "flexible"}

\item{weightclust}{A weight for which the result will be put aside of the other results. This was done for comparative reason and easy access.}
}
\value{
The returned value is a list of four elements:
\item{DistM}{The resulting incidence matrix}
\item{Results}{The hierarchical clustering result for each element in WeightedDist}
\item{Clust}{The result for the weight specified in Clustweight}
The value has class 'CEC'.
}
\description{
Complementary Ensemble Clustering (CEC) Complementary Ensemble Clustering (CEC, \cite{Fodeh2013}) shows similarities with ADEC. 
However, instead of merging the data matrices, ensemble clustering is performedon each data matrix separately. The resulting incidence 
matrices for each data sets are combined in a weighted linear equation. The weighted incidence matrix is the input for the final clustering 
algorithm. Similarly as ADEC, there are versions depending of the specification of the number of features to sample and the number of clusters.
}
\details{
If r is specified and nrclusters is a fixed number, only a random sampling of the features will be performed for the t iterations (CECa). If r is NULL and the nrclusters is a sequence, the clustering is performedon all features and the dendrogam is divided into clusters for the values of nrclusters (CECb). If both r is specified and nrclusters is a sequence, the combination is performed (CECc).
After every iteration, either be random sampling, multiple divisions of the dendrogram or both, an incidence matrix is set up. All incidence matrices are summed and represent the distance matrix on which a final clustering is performed.
}
\examples{
data(fingerprintMat)
data(targetMat)
L=list(fingerprintMat,targetMat)

MCF7_CEC=CEC(List=L,distmeasure=c("tanimoto","tanimoto"),normalize=FALSE,method=NULL
,t=100, r=c(100,100), nrclusters=list(seq(2,10,1),seq(2,10,1)),clust="agnes",linkage=
c("flexible","flexible"),alpha=0.625,weightclust=0.5)
}
\references{
\insertRef{Fodeh2013}{IntClust}
}
