% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{IV}
\alias{IV}
\title{IV}
\usage{
IV(X, Y, valueOfGood = 1)
}
\arguments{
\item{X}{The categorical variable stored as factor for which Information Value (IV) is to be computed.}

\item{Y}{The actual 1/0 flags for the binary response variable. It can take values of either 1 or 0, where 1 represents the 'Good' or 'Events' while 0 represents 'Bad' or 'Non-Events'.}

\item{valueOfGood}{The value in Y that is used to represent 'Good' or the occurence of the event of interest. Defaults to 1.}
}
\value{
The Information Value (IV) for each group in categorical X variable.
}
\description{
Compute the IV for each group of a given categorical X and binary response Y. The resulting WOE can be usued in place of the categorical X so as to be used as a continuous variable.
}
\details{
For a given actual for a Binary Y variable and a categorical X variable stored as factor, the information values are computed.
}
\examples{
data('SimData')
IV(X=SimData$X.Cat, Y=SimData$Y.Binary)
}
\author{
Selva Prabhakaran \email{selva86@gmail.com}
}

