/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleCGS
extends AbstractDoubleIterativeSolver {
    private DoubleMatrix1D p;
    private DoubleMatrix1D q;
    private DoubleMatrix1D u;
    private DoubleMatrix1D phat;
    private DoubleMatrix1D qhat;
    private DoubleMatrix1D vhat;
    private DoubleMatrix1D uhat;
    private DoubleMatrix1D sum;
    private DoubleMatrix1D r;
    private DoubleMatrix1D rtilde;

    public DoubleCGS(DoubleMatrix1D doubleMatrix1D) {
        this.p = doubleMatrix1D.copy();
        this.q = doubleMatrix1D.copy();
        this.u = doubleMatrix1D.copy();
        this.phat = doubleMatrix1D.copy();
        this.qhat = doubleMatrix1D.copy();
        this.vhat = doubleMatrix1D.copy();
        this.uhat = doubleMatrix1D.copy();
        this.sum = doubleMatrix1D.copy();
        this.r = doubleMatrix1D.copy();
        this.rtilde = doubleMatrix1D.copy();
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        doubleMatrix2D.zMult(doubleMatrix1D2, this.r.assign(doubleMatrix1D), -1.0, 1.0, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, doubleMatrix1D2)) {
            d = this.rtilde.zDotProduct(this.r);
            if (d == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (this.iter.isFirst()) {
                this.u.assign(this.r);
                this.p.assign(this.u);
            } else {
                d4 = d / d2;
                this.u.assign(this.r).assign(this.q, DoubleFunctions.plusMultSecond(d4));
                this.sum.assign(this.q).assign(this.p, DoubleFunctions.plusMultSecond(d4));
                this.p.assign(this.u).assign(this.sum, DoubleFunctions.plusMultSecond(d4));
            }
            this.M.apply(this.p, this.phat);
            doubleMatrix2D.zMult(this.phat, this.vhat);
            d3 = d / this.rtilde.zDotProduct(this.vhat);
            this.q.assign(this.vhat, DoubleFunctions.multSecond(-d3)).assign(this.u, DoubleFunctions.plus);
            this.M.apply(this.sum.assign(this.u).assign(this.q, DoubleFunctions.plus), this.uhat);
            doubleMatrix1D2.assign(this.uhat, DoubleFunctions.plusMultSecond(d3));
            doubleMatrix2D.zMult(this.uhat, this.qhat);
            this.r.assign(this.qhat, DoubleFunctions.plusMultSecond(-d3));
            d2 = d;
            this.iter.next();
        }
        return doubleMatrix1D2;
    }
}

