/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.function.tfloat.LongFloatProcedure;
import cern.colt.map.tfloat.AbstractLongFloatMap;
import cern.colt.map.tfloat.OpenLongFloatHashMap;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SelectedSparseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCMFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCMFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import java.io.IOException;

public class SparseFloatMatrix2D
extends FloatMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongFloatMap elements;

    public SparseFloatMatrix2D(float[][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length);
        this.assign(fArray);
    }

    public SparseFloatMatrix2D(int n, int n2) {
        this(n, n2, n * (n2 / 1000), 0.2f, 0.5f);
    }

    public SparseFloatMatrix2D(int n, int n2, int n3, float f, float f2) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongFloatHashMap(n3, f, f2);
    }

    public SparseFloatMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float f) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongFloatHashMap(nArray.length);
        this.insert(nArray, nArray2, f);
    }

    public SparseFloatMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float[] fArray) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongFloatHashMap(nArray.length);
        this.insert(nArray, nArray2, fArray);
    }

    public SparseFloatMatrix2D(MatrixVectorReader matrixVectorReader) throws IOException {
        block9: {
            float[] fArray;
            int[] nArray;
            int[] nArray2;
            int n;
            MatrixInfo matrixInfo;
            block8: {
                MatrixSize matrixSize;
                block7: {
                    matrixInfo = matrixVectorReader.hasInfo() ? matrixVectorReader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                    if (matrixInfo.isPattern()) {
                        throw new UnsupportedOperationException("Pattern matrices are not supported");
                    }
                    if (matrixInfo.isDense()) {
                        throw new UnsupportedOperationException("Dense matrices are not supported");
                    }
                    if (matrixInfo.isComplex()) {
                        throw new UnsupportedOperationException("Complex matrices are not supported");
                    }
                    matrixSize = matrixVectorReader.readMatrixSize(matrixInfo);
                    try {
                        this.setUp(matrixSize.numRows(), matrixSize.numColumns());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                        throw illegalArgumentException;
                    }
                }
                n = matrixSize.numEntries();
                nArray2 = new int[n];
                nArray = new int[n];
                fArray = new float[n];
                matrixVectorReader.readCoordinate(nArray, nArray2, fArray);
                this.elements = matrixInfo.isSymmetric() || matrixInfo.isSkewSymmetric() ? new OpenLongFloatHashMap(2 * nArray.length) : new OpenLongFloatHashMap(nArray.length);
                this.insert(nArray, nArray2, fArray);
                if (!matrixInfo.isSymmetric()) break block8;
                for (int i = 0; i < n; ++i) {
                    if (nArray[i] == nArray2[i]) continue;
                    this.set(nArray2[i], nArray[i], fArray[i]);
                }
                break block9;
            }
            if (!matrixInfo.isSkewSymmetric()) break block9;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                this.set(nArray2[i], nArray[i], -fArray[i]);
            }
        }
    }

    protected SparseFloatMatrix2D(int n, int n2, AbstractLongFloatMap abstractLongFloatMap, int n3, int n4, int n5, int n6) {
        block2: {
            try {
                this.setUp(n, n2, n3, n4, n5, n6);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = abstractLongFloatMap;
        this.isNoView = false;
    }

    public FloatMatrix2D assign(FloatFunction floatFunction) {
        if (this.isNoView && floatFunction instanceof FloatMult) {
            this.elements.assign(floatFunction);
        } else {
            super.assign(floatFunction);
        }
        return this;
    }

    public FloatMatrix2D assign(float f) {
        if (this.isNoView && f == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(f);
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D) {
        if (!(floatMatrix2D instanceof SparseFloatMatrix2D)) {
            return super.assign(floatMatrix2D);
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = (SparseFloatMatrix2D)floatMatrix2D;
        if (sparseFloatMatrix2D == this) {
            return this;
        }
        this.checkShape(sparseFloatMatrix2D);
        if (this.isNoView && sparseFloatMatrix2D.isNoView) {
            this.elements.assign(sparseFloatMatrix2D.elements);
            return this;
        }
        return super.assign(floatMatrix2D);
    }

    public FloatMatrix2D assign(final FloatMatrix2D floatMatrix2D, FloatFloatFunction floatFloatFunction) {
        if (!this.isNoView) {
            return super.assign(floatMatrix2D, floatFloatFunction);
        }
        this.checkShape(floatMatrix2D);
        if (floatFloatFunction instanceof FloatPlusMultSecond) {
            final float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
            if (f == 0.0f) {
                return this;
            }
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f2) {
                    SparseFloatMatrix2D.this.setQuick(n, n2, SparseFloatMatrix2D.this.getQuick(n, n2) + f * f2);
                    return f2;
                }
            });
        } else if (floatFloatFunction == FloatFunctions.mult) {
            this.elements.forEachPair(new LongFloatProcedure(){

                public boolean apply(long l, float f) {
                    int n;
                    int n2 = (int)(l / (long)SparseFloatMatrix2D.this.columns);
                    float f2 = f * floatMatrix2D.getQuick(n2, n = (int)(l % (long)SparseFloatMatrix2D.this.columns));
                    if (f2 != f) {
                        SparseFloatMatrix2D.this.elements.put(l, f2);
                    }
                    return true;
                }
            });
        } else if (floatFloatFunction == FloatFunctions.div) {
            this.elements.forEachPair(new LongFloatProcedure(){

                public boolean apply(long l, float f) {
                    int n;
                    int n2 = (int)(l / (long)SparseFloatMatrix2D.this.columns);
                    float f2 = f / floatMatrix2D.getQuick(n2, n = (int)(l % (long)SparseFloatMatrix2D.this.columns));
                    if (f2 != f) {
                        SparseFloatMatrix2D.this.elements.put(l, f2);
                    }
                    return true;
                }
            });
        } else {
            super.assign(floatMatrix2D, floatFloatFunction);
        }
        return this;
    }

    public SparseFloatMatrix2D assign(int[] nArray, int[] nArray2, float f, FloatFloatFunction floatFloatFunction) {
        int n = nArray.length;
        if (floatFloatFunction == FloatFunctions.plus) {
            for (int i = 0; i < n; ++i) {
                long l = nArray[i];
                long l2 = nArray2[i];
                if (l >= (long)this.rows || l2 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l + ", column: " + l2);
                }
                long l3 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l2 * (long)this.columnStride;
                float f2 = this.elements.get(l3);
                float f3 = f2 + f;
                if (f3 != 0.0f) {
                    this.elements.put(l3, f3);
                    continue;
                }
                this.elements.removeKey(l3);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                long l = nArray[i];
                long l4 = nArray2[i];
                if (l >= (long)this.rows || l4 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l + ", column: " + l4);
                }
                long l5 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l4 * (long)this.columnStride;
                float f4 = this.elements.get(l5);
                float f5 = floatFloatFunction.apply(f4, f);
                if (f5 != 0.0f) {
                    this.elements.put(l5, f5);
                    continue;
                }
                this.elements.removeKey(l5);
            }
        }
        return this;
    }

    public SparseFloatMatrix2D assign(int[] nArray, int[] nArray2, float[] fArray, FloatFloatFunction floatFloatFunction) {
        int n = nArray.length;
        if (floatFloatFunction == FloatFunctions.plus) {
            for (int i = 0; i < n; ++i) {
                float f = fArray[i];
                long l = nArray[i];
                long l2 = nArray2[i];
                if (l >= (long)this.rows || l2 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l + ", column: " + l2);
                }
                long l3 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l2 * (long)this.columnStride;
                float f2 = this.elements.get(l3);
                if ((f += f2) != 0.0f) {
                    this.elements.put(l3, f);
                    continue;
                }
                this.elements.removeKey(l3);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                float f = fArray[i];
                long l = nArray[i];
                long l4 = nArray2[i];
                if (l >= (long)this.rows || l4 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l + ", column: " + l4);
                }
                long l5 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l4 * (long)this.columnStride;
                float f3 = this.elements.get(l5);
                f = floatFloatFunction.apply(f3, f);
                if (f != 0.0f) {
                    this.elements.put(l5, f);
                    continue;
                }
                this.elements.removeKey(l5);
            }
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public SparseCCFloatMatrix2D getColumnCompressed(boolean bl) {
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        float[] fArray = this.elements.values().elements();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            nArray[i] = (int)(l / (long)this.columns);
            nArray2[i] = (int)(l % (long)this.columns);
        }
        return new SparseCCFloatMatrix2D(this.rows, this.columns, nArray, nArray2, fArray, false, false, bl);
    }

    public SparseCCMFloatMatrix2D getColumnCompressedModified() {
        SparseCCMFloatMatrix2D sparseCCMFloatMatrix2D = new SparseCCMFloatMatrix2D(this.rows, this.columns);
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        float[] fArray = this.elements.values().elements();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(lArray[i] / (long)this.columns);
            int n3 = (int)(lArray[i] % (long)this.columns);
            sparseCCMFloatMatrix2D.setQuick(n2, n3, fArray[i]);
        }
        return sparseCCMFloatMatrix2D;
    }

    public SparseRCFloatMatrix2D getRowCompressed(boolean bl) {
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        float[] fArray = this.elements.values().elements();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            nArray[i] = (int)(l / (long)this.columns);
            nArray2[i] = (int)(l % (long)this.columns);
        }
        return new SparseRCFloatMatrix2D(this.rows, this.columns, nArray, nArray2, fArray, false, false, bl);
    }

    public SparseRCMFloatMatrix2D getRowCompressedModified() {
        SparseRCMFloatMatrix2D sparseRCMFloatMatrix2D = new SparseRCMFloatMatrix2D(this.rows, this.columns);
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        float[] fArray = this.elements.values().elements();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(lArray[i] / (long)this.columns);
            int n3 = (int)(lArray[i] % (long)this.columns);
            sparseRCMFloatMatrix2D.setQuick(n2, n3, fArray[i]);
        }
        return sparseRCMFloatMatrix2D;
    }

    public AbstractLongFloatMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public FloatMatrix2D forEachNonZero(final IntIntFloatFunction intIntFloatFunction) {
        if (this.isNoView) {
            this.elements.forEachPair(new LongFloatProcedure(){

                public boolean apply(long l, float f) {
                    int n;
                    int n2 = (int)(l / (long)SparseFloatMatrix2D.this.columns);
                    float f2 = intIntFloatFunction.apply(n2, n = (int)(l % (long)SparseFloatMatrix2D.this.columns), f);
                    if (f2 != f) {
                        SparseFloatMatrix2D.this.elements.put(l, f2);
                    }
                    return true;
                }
            });
        } else {
            super.forEachNonZero(intIntFloatFunction);
        }
        return this;
    }

    public synchronized float getQuick(int n, int n2) {
        return this.elements.get((long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride);
    }

    public long index(int n, int n2) {
        return (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
    }

    public FloatMatrix2D like(int n, int n2) {
        return new SparseFloatMatrix2D(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return new SparseFloatMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, float f) {
        long l = (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
        if (f == 0.0f) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, f);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                float f = this.getQuick(i, j);
                if (f == 0.0f) continue;
                stringBuilder.append('(').append(i).append(',').append(j).append(')').append('\t').append(f).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public FloatMatrix1D vectorize() {
        SparseFloatMatrix1D sparseFloatMatrix1D = new SparseFloatMatrix1D((int)this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                float f = this.getQuick(j, i);
                sparseFloatMatrix1D.setQuick(n++, f);
            }
        }
        return sparseFloatMatrix1D;
    }

    public FloatMatrix1D zMult(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, final float f, float f2, final boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = floatMatrix1D2 == null;
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = new DenseFloatMatrix1D(n);
        }
        if (!(this.isNoView && floatMatrix1D instanceof DenseFloatMatrix1D && floatMatrix1D2 instanceof DenseFloatMatrix1D)) {
            return super.zMult(floatMatrix1D, floatMatrix1D2, f, f2, bl);
        }
        if ((long)n2 != floatMatrix1D.size() || (long)n > floatMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + floatMatrix1D.toStringShort() + ", " + floatMatrix1D2.toStringShort());
        }
        if (!bl2) {
            floatMatrix1D2.assign(FloatFunctions.mult(f2));
        }
        DenseFloatMatrix1D denseFloatMatrix1D = (DenseFloatMatrix1D)floatMatrix1D2;
        final float[] fArray = denseFloatMatrix1D.elements;
        final int n3 = denseFloatMatrix1D.stride();
        final int n4 = (int)floatMatrix1D2.index(0);
        DenseFloatMatrix1D denseFloatMatrix1D2 = (DenseFloatMatrix1D)floatMatrix1D;
        final float[] fArray2 = denseFloatMatrix1D2.elements;
        final int n5 = denseFloatMatrix1D2.stride();
        final int n6 = (int)floatMatrix1D.index(0);
        if (fArray2 == null || fArray == null) {
            throw new InternalError();
        }
        this.elements.forEachPair(new LongFloatProcedure(){

            public boolean apply(long l, float f2) {
                int n = (int)(l / (long)SparseFloatMatrix2D.this.columns);
                int n2 = (int)(l % (long)SparseFloatMatrix2D.this.columns);
                if (bl) {
                    int n32 = n;
                    n = n2;
                    n2 = n32;
                }
                int n42 = n4 + n3 * n;
                fArray[n42] = fArray[n42] + f * f2 * fArray2[n6 + n5 * n2];
                return true;
            }
        });
        return floatMatrix1D2;
    }

    public FloatMatrix2D zMult(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, final float f, float f2, final boolean bl, boolean bl2) {
        boolean bl3;
        if (!this.isNoView) {
            return super.zMult(floatMatrix2D, floatMatrix2D2, f, f2, bl, bl2);
        }
        if (bl2) {
            floatMatrix2D = floatMatrix2D.viewDice();
        }
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = floatMatrix2D.columns();
        boolean bl4 = bl3 = floatMatrix2D2 == null;
        if (floatMatrix2D2 == null) {
            floatMatrix2D2 = new DenseFloatMatrix2D(n, n3);
        }
        if (floatMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? floatMatrix2D.viewDice() : floatMatrix2D).toStringShort());
        }
        if (floatMatrix2D2.rows() != n || floatMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (bl2 ? floatMatrix2D.viewDice() : floatMatrix2D).toStringShort() + ", " + floatMatrix2D2.toStringShort());
        }
        if (this == floatMatrix2D2 || floatMatrix2D == floatMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            floatMatrix2D2.assign(FloatFunctions.mult(f2));
        }
        final FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[n2];
        int n4 = n2;
        while (--n4 >= 0) {
            floatMatrix1DArray[n4] = floatMatrix2D.viewRow(n4);
        }
        final FloatMatrix1D[] floatMatrix1DArray2 = new FloatMatrix1D[n];
        int n5 = n;
        while (--n5 >= 0) {
            floatMatrix1DArray2[n5] = floatMatrix2D2.viewRow(n5);
        }
        final FloatPlusMultSecond floatPlusMultSecond = FloatPlusMultSecond.plusMult(0.0f);
        this.elements.forEachPair(new LongFloatProcedure(){

            public boolean apply(long l, float f2) {
                int n = (int)(l / (long)SparseFloatMatrix2D.this.columns);
                int n2 = (int)(l % (long)SparseFloatMatrix2D.this.columns);
                floatPlusMultSecond.multiplicator = f2 * f;
                if (!bl) {
                    floatMatrix1DArray2[n].assign(floatMatrix1DArray[n2], floatPlusMultSecond);
                } else {
                    floatMatrix1DArray2[n2].assign(floatMatrix1DArray[n], floatPlusMultSecond);
                }
                return true;
            }
        });
        return floatMatrix2D2;
    }

    private void insert(int[] nArray, int[] nArray2, float f) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long l = nArray[i];
            long l2 = nArray2[i];
            if (l >= (long)this.rows || l2 >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + l + ", column: " + l2);
            }
            if (f == 0.0f) continue;
            long l3 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l2 * (long)this.columnStride;
            float f2 = this.elements.get(l3);
            if (f2 == 0.0f) {
                this.elements.put(l3, f);
                continue;
            }
            float f3 = f2 + f;
            if (f3 == 0.0f) {
                this.elements.removeKey(l3);
                continue;
            }
            this.elements.put(l3, f3);
        }
    }

    private void insert(int[] nArray, int[] nArray2, float[] fArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            float f = fArray[i];
            long l = nArray[i];
            long l2 = nArray2[i];
            if (l >= (long)this.rows || l2 >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + l + ", column: " + l2);
            }
            if (f == 0.0f) continue;
            long l3 = (long)this.rowZero + l * (long)this.rowStride + (long)this.columnZero + l2 * (long)this.columnStride;
            float f2 = this.elements.get(l3);
            if (f2 == 0.0f) {
                this.elements.put(l3, f);
                continue;
            }
            float f3 = f2 + f;
            if (f3 == 0.0f) {
                this.elements.removeKey(l3);
                continue;
            }
            this.elements.put(l3, f3);
        }
    }

    protected boolean haveSharedCellsRaw(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D instanceof SelectedSparseFloatMatrix2D) {
            SelectedSparseFloatMatrix2D selectedSparseFloatMatrix2D = (SelectedSparseFloatMatrix2D)floatMatrix2D;
            return this.elements == selectedSparseFloatMatrix2D.elements;
        }
        if (floatMatrix2D instanceof SparseFloatMatrix2D) {
            SparseFloatMatrix2D sparseFloatMatrix2D = (SparseFloatMatrix2D)floatMatrix2D;
            return this.elements == sparseFloatMatrix2D.elements;
        }
        return false;
    }

    protected FloatMatrix1D like1D(int n, int n2, int n3) {
        return new SparseFloatMatrix1D(n, this.elements, n2, n3);
    }

    protected FloatMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseFloatMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

