/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import jdistlib.rng.MersenneTwister;
import jdistlib.rng.RandomEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static final int[] colon(int from, int to) {
        int n = Math.abs(to - from) + 1;
        int[] d = new int[n];
        int inc = to > from ? 1 : -1;
        int i = 0;
        while (i < n) {
            d[i] = from + i * inc;
            ++i;
        }
        return d;
    }

    public static final double[] colon(double from, double to) {
        int n = (int)(Math.abs(to - from) + 1.0);
        double[] d = new double[n];
        int inc = to > from ? 1 : -1;
        int i = 0;
        while (i < n) {
            d[i] = from + (double)(i * inc);
            ++i;
        }
        return d;
    }

    public static final int[] seq(int from, int to, int by) {
        int n = (to - from) / by + 1;
        int[] d = new int[n];
        int i = 0;
        while (i < n) {
            d[i] = from + i * by;
            ++i;
        }
        return d;
    }

    public static final double[] seq_int(double from, double to, int length_out) {
        double[] d = new double[length_out];
        double delta = (to - from) / ((double)length_out - 1.0);
        int i = 0;
        while (i < length_out) {
            d[i] = from + (double)i * delta;
            ++i;
        }
        return d;
    }

    public static final double[] seq(double from, double to, double by) {
        int n = (int)Math.ceil((to - from + 1.0E-15) / by);
        double[] d = new double[n];
        int i = 0;
        while (i < n) {
            d[i] = from + (double)i * by;
            ++i;
        }
        return d;
    }

    public static final int[] c(int[] ... x) {
        int n = 0;
        int i = 0;
        while (i < x.length) {
            n += x[i].length;
            ++i;
        }
        int[] v = new int[n];
        int w = 0;
        int i2 = 0;
        while (i2 < x.length) {
            System.arraycopy(x[i2], 0, v, w, x[i2].length);
            w += x[i2].length;
            ++i2;
        }
        return v;
    }

    public static final int[] c(int ... x) {
        return x;
    }

    public static final double[] c(double[] ... x) {
        int n = 0;
        int i = 0;
        while (i < x.length) {
            n += x[i].length;
            ++i;
        }
        double[] v = new double[n];
        int w = 0;
        int i2 = 0;
        while (i2 < x.length) {
            System.arraycopy(x[i2], 0, v, w, x[i2].length);
            w += x[i2].length;
            ++i2;
        }
        return v;
    }

    public static final double[] c(double ... x) {
        return x;
    }

    public static final double[] rep(double v, int n) {
        double[] r = new double[n];
        Arrays.fill(r, v);
        return r;
    }

    public static final double[] rep(double[] v, int n) {
        double[] r = new double[n * v.length];
        int i = 0;
        while (i < n) {
            System.arraycopy(v, 0, r, i * n, v.length);
            ++i;
        }
        return r;
    }

    public static final double[] rep_each(double[] v, int n) {
        int vn = v.length;
        double[] r = new double[vn * n];
        int i = 0;
        while (i < vn) {
            double vi = v[i];
            int j = 0;
            while (j < n) {
                r[i * n + j] = vi;
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static final int[] rep_each(int[] v, int n) {
        int vn = v.length;
        int[] r = new int[vn * n];
        int i = 0;
        while (i < vn) {
            int vi = v[i];
            int j = 0;
            while (j < n) {
                r[i * n + j] = vi;
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static final double[] rec(double[] e) {
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[i] = 1.0 / e[i];
            ++i;
        }
        return v;
    }

    public static final double[] rev(double[] e) {
        double[] v = new double[e.length];
        int i = 0;
        while (i < e.length) {
            v[e.length - i - 1] = e[i];
            ++i;
        }
        return v;
    }

    public static final void print(double ... val) {
        Utilities.print(" %g", val);
    }

    public static final void print(String format, double ... val) {
        int n = val.length;
        int i = 0;
        while (i < n) {
            System.out.print(String.format(format, val[i]));
            if ((i + 1) % 6 == 0) {
                System.out.println();
            }
            ++i;
        }
        System.out.println();
    }

    public static final void sort(double[] data) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] a = new long[n];
        long[] b = new long[n];
        int i2 = 0;
        while (i2 < n) {
            a[i2] = Double.doubleToLongBits(data[i2]);
            ++i2;
        }
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int[] cntarray = new int[1 << numBins];
            int p = 0;
            while (p < n) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
                ++p;
            }
            int i3 = 1;
            while (i3 < cntarray.length) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
                ++i3;
            }
            p = n - 1;
            while (p >= 0) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                --p;
            }
            long[] temp = b;
            b = a;
            a = temp;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0L) {
            i = n - 1;
            while (a[i] < 0L && i > 0) {
                data[numNegs++] = Double.longBitsToDouble(a[i]);
                --i;
            }
        }
        if (numNegs > 0) {
            i = numNegs;
            while (i < n) {
                data[i] = Double.longBitsToDouble(a[i - numNegs]);
                ++i;
            }
        } else {
            i = 0;
            while (i < n) {
                data[i] = Double.longBitsToDouble(a[i]);
                ++i;
            }
        }
    }

    public static final void sort(double[] data, int[] idx) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] a = new long[n];
        long[] b = new long[n];
        int[] idx_a = new int[n];
        int[] idx_b = new int[n];
        int i2 = 0;
        while (i2 < n) {
            a[i2] = Double.doubleToLongBits(data[i2]);
            idx_a[i2] = idx[i2];
            ++i2;
        }
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int[] cntarray = new int[1 << numBins];
            int p = 0;
            while (p < n) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
                ++p;
            }
            int i3 = 1;
            while (i3 < cntarray.length) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
                ++i3;
            }
            p = n - 1;
            while (p >= 0) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
                --p;
            }
            long[] temp = b;
            b = a;
            a = temp;
            int[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0L) {
            i = n - 1;
            while (a[i] < 0L && i > 0) {
                data[numNegs] = Double.longBitsToDouble(a[i]);
                idx[numNegs++] = idx_a[i];
                --i;
            }
        }
        if (numNegs > 0) {
            i = numNegs;
            while (i < n) {
                data[i] = Double.longBitsToDouble(a[i - numNegs]);
                idx[i] = idx_a[i - numNegs];
                ++i;
            }
        } else {
            i = 0;
            while (i < n) {
                data[i] = Double.longBitsToDouble(a[i]);
                idx[i] = idx_a[i];
                ++i;
            }
        }
    }

    public static final <T> void sort(double[] data, T[] obj) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] a = new long[n];
        long[] b = new long[n];
        Object[] idx_a = new Object[n];
        Object[] idx_b = new Object[n];
        int i2 = 0;
        while (i2 < n) {
            a[i2] = Double.doubleToLongBits(data[i2]);
            idx_a[i2] = obj[i2];
            ++i2;
        }
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int[] cntarray = new int[1 << numBins];
            int p = 0;
            while (p < n) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
                ++p;
            }
            int i3 = 1;
            while (i3 < cntarray.length) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
                ++i3;
            }
            p = n - 1;
            while (p >= 0) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
                --p;
            }
            long[] temp = b;
            b = a;
            a = temp;
            Object[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0L) {
            i = n - 1;
            while (a[i] < 0L && i > 0) {
                data[numNegs] = Double.longBitsToDouble(a[i]);
                obj[numNegs++] = idx_a[i];
                --i;
            }
        }
        if (numNegs > 0) {
            i = numNegs;
            while (i < n) {
                data[i] = Double.longBitsToDouble(a[i - numNegs]);
                obj[i] = idx_a[i - numNegs];
                ++i;
            }
        } else {
            i = 0;
            while (i < n) {
                data[i] = Double.longBitsToDouble(a[i]);
                obj[i] = idx_a[i];
                ++i;
            }
        }
    }

    public static final void sort(int[] a) {
        int[] b;
        int n = a.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        int[] b_orig = b = new int[n];
        int mask = ~(-1 << numBins);
        int rshift = 0;
        while (mask != 0) {
            int[] cntarray = new int[1 << numBins];
            int p = 0;
            while (p < n) {
                int n2 = (a[p] & mask) >>> rshift;
                cntarray[n2] = cntarray[n2] + 1;
                ++p;
            }
            int i = 1;
            while (i < cntarray.length) {
                int n3 = i;
                cntarray[n3] = cntarray[n3] + cntarray[i - 1];
                ++i;
            }
            p = n - 1;
            while (p >= 0) {
                int key;
                int n4 = key = (a[p] & mask) >>> rshift;
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                --p;
            }
            int[] temp = b;
            b = a;
            a = temp;
            mask <<= numBins;
            rshift += numBins;
        }
        if (a == b_orig) {
            System.arraycopy(a, 0, b, 0, n);
        }
        int numNegs = 0;
        int i = n - 1;
        while (a[i] < 0 && i > 0) {
            --i;
            ++numNegs;
        }
        if (numNegs > 0) {
            System.arraycopy(a, n - numNegs, b, 0, numNegs);
            System.arraycopy(a, 0, a, numNegs, n - numNegs);
            System.arraycopy(b, 0, a, 0, numNegs);
        }
    }

    public static final void sort(int[] data, int[] idx) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        int[] a = new int[n];
        int[] b = new int[n];
        int[] idx_a = new int[n];
        int[] idx_b = new int[n];
        int i2 = 0;
        while (i2 < n) {
            a[i2] = data[i2];
            idx_a[i2] = idx[i2];
            ++i2;
        }
        int mask = ~(-1 << numBins);
        int rshift = 0;
        while (mask != 0) {
            int[] cntarray = new int[1 << numBins];
            int p = 0;
            while (p < n) {
                int n2 = (a[p] & mask) >>> rshift;
                cntarray[n2] = cntarray[n2] + 1;
                ++p;
            }
            int i3 = 1;
            while (i3 < cntarray.length) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
                ++i3;
            }
            p = n - 1;
            while (p >= 0) {
                int key;
                int n4 = key = (a[p] & mask) >>> rshift;
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
                --p;
            }
            int[] temp = b;
            b = a;
            a = temp;
            int[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0) {
            i = n - 1;
            while (a[i] < 0 && i > 0) {
                data[numNegs] = a[i];
                idx[numNegs++] = idx_a[i];
                --i;
            }
        }
        if (numNegs > 0) {
            i = numNegs;
            while (i < n) {
                data[i] = a[i - numNegs];
                idx[i] = idx_a[i - numNegs];
                ++i;
            }
        } else {
            i = 0;
            while (i < n) {
                data[i] = a[i];
                idx[i] = idx_a[i];
                ++i;
            }
        }
    }

    public static final <T> void sort(int[] data, T[] idx) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        int[] a = new int[n];
        int[] b = new int[n];
        Object[] idx_a = new Object[n];
        Object[] idx_b = new Object[n];
        int i2 = 0;
        while (i2 < n) {
            a[i2] = data[i2];
            idx_a[i2] = idx[i2];
            ++i2;
        }
        int mask = ~(-1 << numBins);
        int rshift = 0;
        while (mask != 0) {
            int[] cntarray = new int[1 << numBins];
            int p = 0;
            while (p < n) {
                int n2 = (a[p] & mask) >>> rshift;
                cntarray[n2] = cntarray[n2] + 1;
                ++p;
            }
            int i3 = 1;
            while (i3 < cntarray.length) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
                ++i3;
            }
            p = n - 1;
            while (p >= 0) {
                int key;
                int n4 = key = (a[p] & mask) >>> rshift;
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
                --p;
            }
            int[] temp = b;
            b = a;
            a = temp;
            Object[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0) {
            i = n - 1;
            while (a[i] < 0 && i > 0) {
                data[numNegs] = a[i];
                idx[numNegs++] = idx_a[i];
                --i;
            }
        }
        if (numNegs > 0) {
            i = numNegs;
            while (i < n) {
                data[i] = a[i - numNegs];
                idx[i] = idx_a[i - numNegs];
                ++i;
            }
        } else {
            i = 0;
            while (i < n) {
                data[i] = a[i];
                idx[i] = idx_a[i];
                ++i;
            }
        }
    }

    public static final void sort(long[] a) {
        long[] b;
        int n = a.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] b_orig = b = new long[n];
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int[] cntarray = new int[1 << numBins];
            int p = 0;
            while (p < n) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
                ++p;
            }
            int i = 1;
            while (i < cntarray.length) {
                int n3 = i;
                cntarray[n3] = cntarray[n3] + cntarray[i - 1];
                ++i;
            }
            p = n - 1;
            while (p >= 0) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                --p;
            }
            long[] temp = b;
            b = a;
            a = temp;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        if (a == b_orig) {
            System.arraycopy(a, 0, b, 0, n);
        }
        int numNegs = 0;
        int i = n - 1;
        while (a[i] < 0L && i > 0) {
            --i;
            ++numNegs;
        }
        if (numNegs > 0) {
            System.arraycopy(a, n - numNegs, b, 0, numNegs);
            System.arraycopy(a, 0, a, numNegs, n - numNegs);
            System.arraycopy(b, 0, a, 0, numNegs);
        }
    }

    public static final void sort(long[] data, int[] idx) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] a = new long[n];
        long[] b = new long[n];
        int[] idx_a = new int[n];
        int[] idx_b = new int[n];
        int i2 = 0;
        while (i2 < n) {
            a[i2] = data[i2];
            idx_a[i2] = idx[i2];
            ++i2;
        }
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int[] cntarray = new int[1 << numBins];
            int p = 0;
            while (p < n) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
                ++p;
            }
            int i3 = 1;
            while (i3 < cntarray.length) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
                ++i3;
            }
            p = n - 1;
            while (p >= 0) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
                --p;
            }
            long[] temp = b;
            b = a;
            a = temp;
            int[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0L) {
            i = n - 1;
            while (a[i] < 0L && i > 0) {
                data[numNegs] = a[i];
                idx[numNegs++] = idx_a[i];
                --i;
            }
        }
        if (numNegs > 0) {
            i = numNegs;
            while (i < n) {
                data[i] = a[i - numNegs];
                idx[i] = idx_a[i - numNegs];
                ++i;
            }
        } else {
            i = 0;
            while (i < n) {
                data[i] = a[i];
                idx[i] = idx_a[i];
                ++i;
            }
        }
    }

    public static final <T> void sort(long[] data, T[] idx) {
        int i;
        int n = data.length;
        int numBins = (int)Math.max(4L, Math.min(10L, Math.round(Math.log(n) / (2.0 * Math.log(2.0)))));
        long[] a = new long[n];
        long[] b = new long[n];
        Object[] idx_a = new Object[n];
        Object[] idx_b = new Object[n];
        int i2 = 0;
        while (i2 < n) {
            a[i2] = data[i2];
            idx_a[i2] = idx[i2];
            ++i2;
        }
        long mask = -1L << numBins ^ 0xFFFFFFFFFFFFFFFFL;
        long rshift = 0L;
        while (mask != 0L) {
            int[] cntarray = new int[1 << numBins];
            int p = 0;
            while (p < n) {
                int n2 = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n2] = cntarray[n2] + 1;
                ++p;
            }
            int i3 = 1;
            while (i3 < cntarray.length) {
                int n3 = i3;
                cntarray[n3] = cntarray[n3] + cntarray[i3 - 1];
                ++i3;
            }
            p = n - 1;
            while (p >= 0) {
                int key;
                int n4 = key = (int)((a[p] & mask) >>> (int)rshift);
                cntarray[n4] = cntarray[n4] - 1;
                b[cntarray[key]] = a[p];
                idx_b[cntarray[key]] = idx_a[p];
                --p;
            }
            long[] temp = b;
            b = a;
            a = temp;
            Object[] temp_idx = idx_b;
            idx_b = idx_a;
            idx_a = temp_idx;
            mask <<= numBins;
            rshift += (long)numBins;
        }
        int numNegs = 0;
        if (a[n - 1] < 0L) {
            i = n - 1;
            while (a[i] < 0L && i > 0) {
                data[numNegs] = a[i];
                idx[numNegs++] = idx_a[i];
                --i;
            }
        }
        if (numNegs > 0) {
            i = numNegs;
            while (i < n) {
                data[i] = a[i - numNegs];
                idx[i] = idx_a[i - numNegs];
                ++i;
            }
        } else {
            i = 0;
            while (i < n) {
                data[i] = a[i];
                idx[i] = idx_a[i];
                ++i;
            }
        }
    }

    public static final double[] to_double(int[] e) {
        int n = e.length;
        double[] r = new double[n];
        int i = 0;
        while (i < n) {
            r[i] = e[i];
            ++i;
        }
        return r;
    }

    public static final int[] order(double[] e) {
        int n = e.length;
        int[] order = new int[n];
        double[] v = new double[n];
        System.arraycopy(e, 0, v, 0, n);
        int i = 0;
        while (i < n) {
            order[i] = i;
            ++i;
        }
        Utilities.sort(v, order);
        return order;
    }

    public static final double[] rank(double[] e) {
        return Utilities.rank(e, RankTies.AVERAGE);
    }

    public static final double[] rank(double[] e, RankTies ties) {
        int n = e.length;
        int[] order = new int[n];
        double[] rank = new double[n];
        double[] v = new double[n];
        System.arraycopy(e, 0, v, 0, n);
        int i = 0;
        while (i < n) {
            order[i] = i;
            ++i;
        }
        Utilities.sort(v, order);
        int i2 = 0;
        while (i2 < n) {
            int j = i2;
            while (j < n - 1 && v[j] == v[j + 1]) {
                ++j;
            }
            switch (ties) {
                case AVERAGE: {
                    double avg = (double)(i2 + j) / 2.0;
                    int k = i2;
                    while (k <= j) {
                        rank[order[k]] = avg + 1.0;
                        ++k;
                    }
                    break;
                }
                case MAX: {
                    int k = i2;
                    while (k <= j) {
                        rank[order[k]] = j + 1;
                        ++k;
                    }
                    break;
                }
                case MIN: {
                    int k = i2;
                    while (k <= j) {
                        rank[order[k]] = i2 + 1;
                        ++k;
                    }
                    break;
                }
            }
            i2 = j + 1;
        }
        return rank;
    }

    public static final void permute(double[] e) {
        Utilities.permute(e, new MersenneTwister());
    }

    public static final void permute(double[] e, RandomEngine random) {
        int n = e.length;
        int i = 0;
        while (i < n) {
            int i1 = random.nextInt(n);
            int i2 = random.nextInt(n);
            double t = e[i1];
            e[i1] = e[i2];
            e[i2] = t;
            ++i;
        }
    }

    public static final double[] sample_int(int n, int s) {
        return Utilities.sample_int(n, s, new MersenneTwister());
    }

    public static final double[] sample_int(int n, int s, RandomEngine random) {
        double[] rand = new double[s];
        HashSet<Integer> set = new HashSet<Integer>();
        int i = 0;
        while (i < s) {
            int j;
            while (set.contains(j = (int)(Math.floor(random.random() * (double)n) + 1.0))) {
            }
            set.add(j);
            rand[i] = j;
            ++i;
        }
        return rand;
    }

    public static final double[] unique(double[] e) {
        LinkedHashSet<Double> set = new LinkedHashSet<Double>(e.length);
        double[] dArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            double _e = dArray[n2];
            set.add(_e);
            ++n2;
        }
        int n3 = set.size();
        int i = 0;
        double[] r = new double[n3];
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            double _e = (Double)iterator.next();
            r[i++] = _e;
        }
        return r;
    }

    public static final <S> S[] unique(S[] e) {
        LinkedHashSet<S> set = new LinkedHashSet<S>(e.length);
        S[] SArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            S _e = SArray[n2];
            set.add(_e);
            ++n2;
        }
        return set.toArray();
    }

    public static final boolean[] is_duplicated(double[] e) {
        LinkedHashSet<Double> set = new LinkedHashSet<Double>(e.length);
        int n = e.length;
        int i = 0;
        boolean[] r = new boolean[n];
        double[] dArray = e;
        int n2 = e.length;
        int n3 = 0;
        while (n3 < n2) {
            double _e = dArray[n3];
            r[i++] = set.contains(_e);
            set.add(_e);
            ++n3;
        }
        return r;
    }

    public static final <S> boolean[] is_duplicated(S[] e) {
        LinkedHashSet<S> set = new LinkedHashSet<S>(e.length);
        int n = e.length;
        int i = 0;
        boolean[] r = new boolean[n];
        S[] SArray = e;
        int n2 = e.length;
        int n3 = 0;
        while (n3 < n2) {
            S _e = SArray[n3];
            r[i++] = set.contains(_e);
            set.add(_e);
            ++n3;
        }
        return r;
    }

    public static final int[] which(boolean[] e) {
        int n = e.length;
        int n_true = 0;
        int j = 0;
        boolean[] blArray = e;
        int n2 = e.length;
        int n3 = 0;
        while (n3 < n2) {
            boolean _e = blArray[n3];
            if (_e) {
                ++n_true;
            }
            ++n3;
        }
        int[] idx = new int[n_true];
        int i = 0;
        while (i < n) {
            if (e[i]) {
                idx[j++] = i;
            }
            ++i;
        }
        return idx;
    }

    public static final double[][] rle(double[] e) {
        ArrayList<Double> vals = new ArrayList<Double>();
        ArrayList<Integer> lens = new ArrayList<Integer>();
        double last_val = e[0];
        int last_ct = 1;
        int n = e.length;
        int i = 1;
        while (i < n) {
            if (e[i] != last_val) {
                vals.add(last_val);
                lens.add(last_ct);
                last_val = e[i];
                last_ct = 1;
            } else {
                ++last_ct;
            }
            ++i;
        }
        vals.add(last_val);
        lens.add(last_ct);
        n = vals.size();
        double[] uvals = new double[n];
        double[] ulen = new double[n];
        int i2 = 0;
        while (i2 < n) {
            uvals[i2] = (Double)vals.get(i2);
            ulen[i2] = ((Integer)lens.get(i2)).intValue();
            ++i2;
        }
        return new double[][]{uvals, ulen};
    }

    public static final int[] match(double[] x, double[] y) {
        int nx = x.length;
        int ny = y.length;
        int[] r = new int[nx];
        int i = 0;
        while (i < nx) {
            r[i] = -1;
            int j = 0;
            while (j < ny) {
                if (x[i] == y[j]) {
                    r[i] = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static final int[] match(int[] x, int[] y) {
        int nx = x.length;
        int ny = y.length;
        int[] r = new int[nx];
        int i = 0;
        while (i < nx) {
            r[i] = -1;
            int j = 0;
            while (j < ny) {
                if (x[i] == y[j]) {
                    r[i] = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static final <S> int[] match(S[] x, S[] y) {
        int nx = x.length;
        int ny = y.length;
        int[] r = new int[nx];
        int i = 0;
        while (i < nx) {
            r[i] = -1;
            int j = 0;
            while (j < ny) {
                if (x[i].equals(y[j])) {
                    r[i] = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static final int[] tabulate(int[] x, int n) {
        int nx = x.length;
        int[] r = new int[n];
        int i = 0;
        while (i < nx) {
            int n2 = x[i];
            r[n2] = r[n2] + 1;
            ++i;
        }
        return r;
    }

    public static final int[] seq_along(double[] z) {
        return Utilities.colon(1, z.length);
    }

    public static final double[] index(double[] x, int[] idx) {
        int n = idx.length;
        double[] r = new double[n];
        int i = 0;
        while (i < n) {
            r[i] = x[idx[i]];
            ++i;
        }
        return r;
    }

    public static final double[] index_min1(double[] x, int[] idx) {
        int n = idx.length;
        double[] r = new double[n];
        int i = 0;
        while (i < n) {
            r[i] = x[idx[i] - 1];
            ++i;
        }
        return r;
    }

    public static final int[] to_int_array(Collection<Integer> s) {
        int n = s.size();
        int[] r = new int[n];
        int i = 0;
        for (int _s : s) {
            r[i++] = _s;
        }
        return r;
    }

    public static final double[] to_double_array(Collection<Double> s) {
        int n = s.size();
        double[] r = new double[n];
        int i = 0;
        for (double _s : s) {
            r[i++] = _s;
        }
        return r;
    }

    public static final boolean any(boolean ... x) {
        boolean[] blArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _x = blArray[n2];
            if (_x) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean anyNA(double ... x) {
        double[] dArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            double _x = dArray[n2];
            if (Double.isNaN(_x)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RankTies {
        AVERAGE,
        MAX,
        MIN;

    }
}

