% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imIM4E.R
\name{imIM4E}
\alias{imIM4E}
\title{imIM4E}
\usage{
imIM4E(xx, yy, epsilon = 0.01, sig = 1, rho = 1, lambda = 1,
  max_iter = 10, removesmall = FALSE)
}
\arguments{
\item{xx}{model matrix of explanatory variables}

\item{yy}{label vector}

\item{epsilon}{criterion for stopping iteration}

\item{sig}{sigma used in algorithm, default to be 1}

\item{rho}{rho used in algorithm, default to be 1}

\item{lambda}{lambda used in algorithm, default to be 1}

\item{max_iter}{maximum number of iteration}

\item{removesmall}{whether remove features with small weights, default to be FALSE}
}
\value{
\item{ w}{new weight after one loop}

\item{ iter_num}{ number of iteration for convergence}

\item{ final_c}{ final cost}
}
\description{
This function performs imIM4E(imbalance Iterative Margin-Maximization under Max-Min entropy) algorithm.
}
\examples{
data(park)
xx<-park$xx
yy<-park$yy
re<-imIM4E(xx,yy)
print(re)
}
\keyword{imIM4E}
