% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GA.Dscore.R
\name{GA.Dscore}
\alias{GA.Dscore}
\title{Search For A Subset With The Highest D-score}
\usage{
GA.Dscore(
  K,
  size,
  keep = c(),
  n0 = size,
  mut = 3,
  cri = 10000,
  console = FALSE
)
}
\arguments{
\item{K}{matrix. An n*n matrix denotes the genomic relationship matrix of
the n candidate individuals, where n > 4.}

\item{size}{integer. An integer denotes the size of the subset, note that
3 < size < n.}

\item{keep}{vector. A vector indicates those candidate individuals which
will be retained in the subset before the search. The length of keep must
be less than size.}

\item{n0}{integer. An integer indicates the number of chromosomes
(solutions) in the genetic algorithm, note that n0 > 3.}

\item{mut}{integer. An integer indicates the number of mutations in the
genetic algorithm, note that mut < size.}

\item{cri}{integer. An integer indicates the stopping criterion, note that
cri < 1e+06. The genetic algorithm will stop if the number of iterations
reaches cri.}

\item{console}{logical. A logical variable, if console is set to be TRUE,
the searching process will be shown in the R console.}
}
\value{
\item{subset}{The optimal subset with the highest D-score.}
\item{D.score}{The D.score of the optimal subset.}
\item{time}{The number of iterations.}
}
\description{
Search for an optimal subset of the candidate individuals such that it
achieves the highest D-score by genetic algorithm (GA).
}
\examples{
# generate simulated data
geno.test <- matrix(sample(c(1, -1), 600, replace = TRUE), 20, 30)
K.test <- geno.test\%*\%t(geno.test)/ncol(geno.test)

# run with no specified individual
result1 <- GA.Dscore(K.test, 6, cri = 1000, console = TRUE)
result1

# run with some specified individuals
result2 <- GA.Dscore(K.test, 6, keep = c(1, 5, 10), cri = 1000, console = TRUE)
result2
}
\references{
Chung PY, Liao CT. 2020. Identification of superior parental lines for
biparental crossing via genomic prediction. PLoS ONE 15(12):e0243159.

Ou JH, Liao CT. 2019. Training set determination for genomic selection.
Theor Appl Genet. 132:2781-2792.
}
