% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBLUP.fit.R
\name{GBLUP.fit}
\alias{GBLUP.fit}
\title{Muti-trait GBLUP Model}
\usage{
GBLUP.fit(phe, geno = NULL, K = NULL)
}
\arguments{
\item{phe}{matrix. An n*t matrix contains the phenotypic values of the t target
traits.}

\item{geno}{matrix. An n*p matrix with n individuals and p markers of the
training population. The markers must be coded as 1, 0, or -1 for alleles AA,
Aa, or aa. The missing value must have been already imputed.}

\item{K}{matrix. An n*n matrix denotes the genomic relationship matrix of the
training population if geno is set to be NULL.}
}
\value{
The fitted values of the training population.
}
\description{
Built the muti-trait GBLUP model using the phenotypic and genotypic data of a
training population by 'mmer' from R package 'sommer'. Then, output the fitted
values of the training population.
}
\examples{
# generate simulated data
phe.test <- data.frame(trait1 = rnorm(50,30,10), trait2 = rnorm(50,10,5), trait3 = rnorm(50,20,20))

# run with the marker score matrix
geno.test <- matrix(sample(c(1, -1), 5000, replace = TRUE), 50, 100)
result1 <- GBLUP.fit(phe.test, geno.test)
result1

# run with the genomic relationship matrix
K.test <- geno.test\%*\%t(geno.test)/ncol(geno.test)
result2 <- GBLUP.fit(phe.test, K = K.test)
result2
}
\references{
Habier D, Fernando RL, Dekkers JCM. 2007. The impact of genetic relationship
information on genome-assisted breeding values. Genetics 177:2389-2397.

VanRaden PM. 2008. Efficient methods to compute genomic predictions.
J Dairy Sci. 91:4414-4423.
}
\seealso{
\code{\link[sommer]{mmer}}
}
