% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{Plot.RT.ECDF_AUC}
\alias{Plot.RT.ECDF_AUC}
\alias{Plot.RT.ECDF_AUC.DataSetList}
\title{Radarplot of the area under the aggregated ECDF-curve of a DataSetList.}
\usage{
Plot.RT.ECDF_AUC(
  dsList,
  fstart = NULL,
  fstop = NULL,
  fstep = NULL,
  fval_formatter = as.integer
)

\method{Plot.RT.ECDF_AUC}{DataSetList}(
  dsList,
  fstart = NULL,
  fstop = NULL,
  fstep = NULL,
  fval_formatter = as.integer
)
}
\arguments{
\item{dsList}{A DataSetList (should consist of only one function and dimension).}

\item{fstart}{The starting function value}

\item{fstop}{The final function value}

\item{fstep}{The spacing between starting and final function values}

\item{fval_formatter}{Function to format the function-value labels}
}
\value{
A radarplot of the area under the aggregated ECDF-curve of the DataSetList
}
\description{
Radarplot of the area under the aggregated ECDF-curve of a DataSetList.
}
\examples{
Plot.RT.ECDF_AUC(subset(dsl, funcId == 1))
}
