% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSetList.R
\name{DataSetList}
\alias{DataSetList}
\title{S3 constructor of the 'DataSetList'}
\usage{
DataSetList(path = NULL, verbose = T, print_fun = NULL,
  maximization = TRUE, format = IOHprofiler, subsampling = FALSE)
}
\arguments{
\item{path}{Path to the data files. Will look for all .info-files in this directory and use
the corresponding datafiles to create the DataSetList}

\item{verbose}{Logical.}

\item{print_fun}{Function used to print output when in verbose mode}

\item{maximization}{Logical. Whether the underlying optimization algorithm performs a maximization?}

\item{format}{A character. The format of data source, either 'IOHProfiler', 'COCO' or 'TWO_COL"}

\item{subsampling}{Logical. Whether *.cdat files are subsampled?}
}
\value{
A DataSetList object
}
\description{
Attributes
  funId
  DIM
  algId
}
\examples{
path <- system.file("extdata", "ONE_PLUS_LAMDA_EA", package="IOHanalyzer")
DataSetList(path)
}
