% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSet.R
\name{DataSet}
\alias{DataSet}
\title{Constructor of S3 class 'DataSet'}
\usage{
DataSet(info, verbose = F, maximization = TRUE, format = IOHprofiler,
  subsampling = FALSE)
}
\arguments{
\item{info}{A List. Contains a set of in a *.info file.}

\item{verbose}{Logical.}

\item{maximization}{Logical. Whether the underlying optimization algorithm performs a maximization?}

\item{format}{A character. The format of data source, either 'IOHProfiler', 'COCO' or 'TWO_COL"}

\item{subsampling}{Logical. Whether *.cdat files are subsampled?}
}
\value{
A S3 object 'DataSet'
}
\description{
DataSet contains the following attributes
 * funId
 * DIM
 * algId
 * Precision
 * datafile
 * instance
 * maxEvals
 * finalFunEvals
 * comment
}
\examples{
path <- system.file("extdata", "ONE_PLUS_LAMDA_EA", package="IOHanalyzer")
info <- read_IndexFile(file.path(path,"IOHprofiler_f1_i1.info"))
DataSet(info[[1]])
}
