% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barrierModel.define.R
\name{barrierModel.define}
\alias{barrierModel.define}
\title{Define a spacetime model object for the \code{f()} call.}
\usage{
barrierModel.define(
  mesh,
  barrierTriangles,
  control.priors,
  fraction = 0.2,
  constr = FALSE,
  debug = FALSE,
  verbose = FALSE,
  useINLAprecomp = TRUE,
  libpath = NULL
)
}
\arguments{
\item{mesh}{a spatial mesh}

\item{barrierTriangles}{a integer vector to specify which
triangles centers are in the barrier domain}

\item{control.priors}{a named list with parameter priors.
E.g. prior.rs and prior.sigma
as vectors with length two (U, a) to define the
corresponding PC-prior such that
P(r_s<U)=a and P(sigma>U)=a.
If a=0 then U is taken to be the fixed value of the parameter.}

\item{fraction}{numeric to specify the fraction of the range
for the barrier domain. Default value is 0.2.}

\item{constr}{logical to indicate if the integral of the field
over the domain is to be constrained to zero. Default value is FALSE.}

\item{debug}{logical indicating if to run in debug mode.}

\item{verbose}{logical indicating if to print parameter values.}

\item{useINLAprecomp}{logical indicating if is to be used
shared object pre-compiled by INLA. Not considered if
libpath is provided.}

\item{libpath}{string to the shared object. Default is NULL.}
}
\value{
objects to be used in the f() formula term in INLA.
}
\description{
Define a spacetime model object for the \code{f()} call.
}
\details{
See the paper.
}
