% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INCATome.R
\docType{package}
\name{INCATome}
\alias{INCATome}
\alias{INCATome-package}
\title{Internal Control Analysis of Translatome Studies by Microarrays}
\description{
Data analysis, normalisation and differential expression for Translatome studies by microarrays by means of a new statistical workflow which avoids interfering with data skewness in the identification of deregulated genes.
}
\details{
\strong{INCATome Package Overview}

Common microarray processing procedures (including for normalisation and statistical identification of deregulation) assume that deregulation must occur in low proportion (below 10\%) and in equal symmetry (approx. equal number of upregulated and downregulated genes). However, we have shown that translatome studies in general violate these assumptions (Sbarrato \emph{et al}, \strong{RNA}, 2017 Aug 25, \href{http://rnajournal.cshlp.org/content/early/2017/08/25/rna.060525.116.abstract}{DOI:10.1261/rna.060525.116}). This package can be implemented for the processing and statistical analysis of microarray datasets presenting inherent skewness due to the samples' nature causing violation of the aforementioned assumptions. INCATome workflow can be segmented as follows:

\enumerate{
   \item \emph{Preprocessing and Quality Check:} INCATome workflow requires an RGList object containing the array data (for example output from \code{\link[limma]{read.maimages}} function of the limma package). First, the RGList is corrected for background with \code{\link{INCA.PreProcess}}, based on the limma package but insuring correct formatting of the output for the rest of the workflow. Users can select their correction method of choice in the arguments. Two graphical tools are at the user's disposal to perform quality checks on the data: 1) \code{\link{INCA.MAPlot}}, which allows to plot MA plots for each array and highlights a given set of control genes (SpikeIn probes and/or Internal References for example) and 2) \code{\link{INCA.SpikePlot}} which allows visual verification of linearity of SpikeIn probe signals on each array.
   \item \emph{Normalisation and Dyeswapping:} The normalization approach implemented with INCATome for translatome analysis is based on the root mean square deviation (RMSD) of internal controls. These can be represented by either the use of 1) the \code{\link{INCA.NormSI}} function requiring Spike-In controls that are independent of the sample and of known concentrations or by the use of 2) the \code{\link{INCA.NormIC}} function requiring Internal References chosen by the user and experimentally validated. The main advantage of this implementation is that the expected values for these given probes are already at hand to the user before the experiment is performed (Spike-In expected values given by Spike-In concentration ratios or Internal References expected values given by at least two northern blotting/qPCR quality controls for subpolysomal and polysomal associations i.e. ACTB and PABP respectively). As a consequence, the RMSD values can be computed between expected and observed values for these probes in order to normalise the data. This procedure results in a within sample normalisation (to the expected levels of the given INCA probes for each sample) as well as a general scaling method across the samples (all tied to the same set of INCA probes). Finally, optional dyeswapping implementation by the \code{\link{INCA.DyeSwap}} function can be used whereby arrays dyeswapped will be reduced by averaging corresponding paired channels.
   \item \emph{Statistical Identification of Deregulation:} The aim of INCATome statistical pipeline with \code{\link{INCA.DEG}} is to reduce the false positive hits by combining four different statistical approaches to assess deregulation: a Welch T-Test \code{\link[genefilter]{rowFtests}}, the parametric Linear Models for Microarray (limma \code{\link[limma]{lmFit}} and \code{\link[limma]{eBayes}}), the non-parametric rank-based approach (RankProd \code{\link[RankProd]{RP}}) and the nonparametric variance-based Significance Analysis of Microarrays (SAM \code{\link[siggenes]{d.stat}}). The improved identification of significantly deregulated genes delivered by INCATome consists of selecting significant candidates (pvalue<=0.05) from each statistical test and assigning a confidence score corresponding to the number of tests concurring on the deregulation (high confidence:  score=4; low confidence: score=2). Genes identified in only one test out of four implemented or with a fold change between -0.5 and 2 are not considered as being candidates for deregulation under INCATome implementation. Additionaly, users have the opportunity prior of performing the statistical testing to filter out a set of genes which possess a ratio ranging between the (mean +/- 1.5*standard deviation) of negative control probes.
}
}
\references{
Sbarrato T., Spriggs R.V., Wilson L., Jones C., Dudek K., Bastide A., Pichon X., Poyry T. and Willis A.E. \strong{RNA}, (2017 Aug 25), An Improved Analysis Methodology for Translational Profiling by Microarray, \href{http://rnajournal.cshlp.org/content/early/2017/08/25/rna.060525.116.abstract}{DOI:10.1261/rna.060525.116}
}
\author{
Sbarrato T. [cre,aut], Spriggs R.V. [cre,aut], Wilson L. [ctb], Jones C. [ctb], Dudek K. [ctb], Bastide A. [ctb], Pichon X. [ctb], Poyry T. [ctb] and Willis A.E. [ctb]

Maintainer: Thomas Sbarrato <thomas.sbarrato@inserm.fr>
}
