% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igraph_from_matrices.R
\name{igraph_from_matrices}
\alias{igraph_from_matrices}
\title{Transforming matrices into network}
\usage{
igraph_from_matrices(mat1, mat2, isDirected1 = TRUE, isDirected2 = TRUE)
}
\arguments{
\item{mat1}{A numeric matrix(or data.frame) representing interactions between two groups of species.Each row and column of matrix represents the species in the first and second layers of the tripartite network respectively.
Elements of matrix are non-zero numebers if the interlayer species are connected, and 0 otherwise.}

\item{mat2}{A numeric matrix(or data.frame) representing interactions between two groups of species.Each row and column of matrix represents the species in the second and third layers of the tripartite network respectively.
Elements of matrix are non-zero numebers if the interlayer species are connected, and 0 otherwise.}

\item{isDirected1}{Logical. Whether the interaction between the two groups of species in \code{mat1} is unidirectional.Default to TRUE, such as Predation and Herbivory. Otherwise it is bidirectional, such as Mutualism.}

\item{isDirected2}{Logical. Whether the interaction between the two groups of species in \code{mat2} is unidirectional.Default to TRUE, such as Predation and Herbivory. Otherwise it is bidirectional, such as Mutualism.}
}
\value{
Return a network of type "igraph".
}
\description{
Two matrices contain three groups of tropical level species. A multilayer network can be transformed from existing matrices data.
}
\details{
\strong{mat1} and \strong{mat2}
Make sure that the columns of \code{mat1} correspond strictly to the rows of \code{mat2}:
\itemize{
\item{The number of columns of \code{mat1} is equal to the number of rows of \code{mat2}.}

\item{If both \code{mat1} and \code{mat2} have row and column names, then the column name of \code{mat1} must also correspond to the row name of \code{mat2}.}
\item{Or the rows and columns of \code{mat1} and \code{mat2} could be empty.}}
}
\examples{

set.seed(12)
MAT <- build_net(11,22,21,0.2,asmatrices=TRUE)
MAT[[1]]

M <- igraph_from_matrices(MAT[[3]],MAT[[4]])
M
}
