% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lab.fqcs.R
\name{plot.lab.fqcs}
\alias{plot.lab.fqcs}
\title{Plotting method for 'lab.fqcs' objects}
\usage{
\method{plot}{lab.fqcs}(x, main = NULL, xlab = NULL, ylab = NULL,
  ylim = NULL, x.co = NULL, y.co = NULL, legend = TRUE, col = NULL,
  ...)
}
\arguments{
\item{x}{Object functional data or a list with objects of functional data type}

\item{main}{Main title for the plot}

\item{xlab}{Title for the x axis}

\item{ylab}{Title for the y axis}

\item{ylim}{The y limits of the plot}

\item{x.co}{It speficies the x co-ordinates to be used to place a legend.}

\item{y.co}{It specifies the y co-ordinates to be used to place a legend.}

\item{legend}{Logical argument. Default is TRUE then The legend default is used.}

\item{col}{Color specifications}

\item{...}{arguments to be passed to or from methods}
}
\description{
Generic function to plot objects of 'lab.fqcs' class. Results of functional ILS studies are graphically shown.
}
\examples{
library(ILS)
data(TG)
delta <- seq(from = 40 ,to = 850 ,length.out = 1000 )
curves.fqcd <- lab.fqcd(TG, argvals = delta)
curves.fqcs <- lab.fqcs(curves.fqcd)
summary(curves.fqcs)
names(curves.fqcs)
class(curves.fqcs$mean.i)
xlab <- "Temperature/ C"
ylab <- "Mass/ \%"
main <- "Functional Mean Estimation by Laboratory"
p <- dim(curves.fqcd$curves)[3]
col <- 1:p
plot(curves.fqcs$mean.i,main = main, xlab = xlab, ylab = ylab, col = col,legend = FALSE)
legend(45,70,paste("Lab",1:p),
      col = col,lty = 1,lwd = 2,cex = 0.7)
}
\references{
\describe{
  \item{}{Febrero-Bande, M. and Oviedo, M. (2012),
   "Statistical computing in functional data analysis: the R package fda.usc". Journal of Statistical Software 51 (4), 1-28.}
  \item{}{Naya, S., Tarrio-Saavedra. J., Lopez- Beceiro, J., Francisco Fernandez, M., Flores, M. and  Artiaga, R. (2014), 
  "Statistical functional approach for interlaboratory studies with thermal data". Journal of Thermal Analysis and Calorimetry, 118,1229-1243.}
}
}

