% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcs.R
\name{readFCSheader}
\alias{readFCSheader}
\title{FCS Header Parser}
\usage{
readFCSheader(fileName, header, encoding = "UTF-8", ...)
}
\arguments{
\item{fileName}{path to file.}

\item{header, }{a list whose members define the "at" offset from header$start$at and the "n" number of bytes to extract:\cr
- start: where to start reading current FCS dataset.       Default is list(at = 0,  n = 6),\cr
- space: where to retrieve space.                          Default is list(at = 6,  n = 4),\cr
- text_beg: where to retrieve file text segment beginning. Default is list(at = 10, n = 8),\cr
- text_end: where to retrieve file text segment end.       Default is list(at = 18, n = 8),\cr
- data_beg: where to retrieve file data segment beginning. Default is list(at = 26, n = 8),\cr
- data_end: where to retrieve file data segment end.       Default is list(at = 34, n = 8).}

\item{encoding}{name of the encoding for raw to character conversion. Default is "UTF-8".}

\item{...}{other arguments to be passed.}
}
\description{
Helper to parse header segment from Flow Cytometry Standard (FCS) compliant files.
}
\keyword{internal}
