% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectTransform.R
\name{objectTransform}
\alias{objectTransform}
\title{Object Transformation}
\usage{
objectTransform(
  mat,
  msk,
  color,
  input_range,
  mode,
  type,
  add_noise = TRUE,
  random_seed = NULL,
  size = c(0, 0),
  bg_mean = 0,
  bg_sd = 0,
  full_range = FALSE,
  force_range = FALSE,
  gamma = 1
)
}
\arguments{
\item{mat}{a finite numeric matrix.}

\item{msk}{a finite numeric matrix (mask identifying abnormalities). If missing, the default no cleansing will be done.}

\item{color}{a color.}

\item{input_range}{a finite numeric vector of 2 values, sets the 'input_range' of the input intensity values; values exceeding this 'input_range' are clipped.}

\item{mode}{color mode export. Either "rgb", "gray" or "raw".}

\item{type}{image object type.}

\item{add_noise}{logical, if TRUE adds normal noise to background using rnorm(), from \pkg{Rcpp}. Default is TRUE.}

\item{random_seed}{a single value, interpreted as an integer, or NULL to be used with set.seed() from \pkg{base} when 'add_noise' is set to TRUE. Default is NULL.}

\item{size}{a length 2 integer vector of final dimensions of the image, height 1st and width 2nd. Default is c(0,0) for no change.}

\item{bg_mean}{mean value of the background added. Default is 0.}

\item{bg_sd}{standard deviation of the background added. Default is 0.}

\item{full_range}{logical, only apply when mode is not "raw", if 'full_range' is TRUE, then input_range will be set to c(0, 4095) and 'gamma' forced to 1. Default is FALSE.}

\item{force_range}{logical, only apply when mode is not "raw", if 'force_range' is TRUE, then input_range will be adjusted to object range in [-4095, +Inf] and 'gamma' forced to 1. Default is FALSE.\cr
Note that this parameter takes the precedence over 'input_range' and 'full_range'.}

\item{gamma}{gamma correction. Default is 1, for no correction.}
}
\value{
the matrix transformed according to input parameters
}
\description{
Function to normalize, colorize and add background to images.
}
\details{
When 'add_noise' is FALSE and 'msk', `removal` attribute has value "masked" or "MC",
backgound will be automatically set to minimal pixel value.
}
\keyword{internal}
