% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.pi.permute}
\alias{get.pi.permute}
\title{get the null distribution of the \code{get.pi} function}
\usage{
get.pi.permute(
  posmat,
  fun,
  r = 1,
  r.low = rep(0, length(r)),
  permutations,
  data.frame = TRUE
)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{fun}{the function to evaluate}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{permutations}{the number of permute iterations}

\item{data.frame}{logical indicating whether to return results as a data frame (default = TRUE)}
}
\value{
pi values for all the distances we looked at
}
\description{
Does permutations to calculate the null distribution of get pi
if there were no spatial dependence. Randomly reassigns coordinates
to each observation permutations times
}
\examples{
\donttest{

#compare normally distributed with uniform points
x<-cbind(1,runif(100,-100,100), runif(100,-100,100))
x<-rbind(x, cbind(2,rnorm(100,0,20), rnorm(100,0,20)))
colnames(x) <- c("type","x","y")

fun<-function(a,b) {
    if(a[1]!=2) return(3)
    if (b[1]==2) return(1)
    return(2)
}

r.max<-seq(10,100,10)
r.min<-seq(0,90,10)
r.mid <- (r.max+r.min)/2

pi<-get.pi(x,fun,r=r.max,r.low=r.min)
pi.null<-get.pi.permute(x,fun,r=r.max,r.low=r.min,permutations=100)

null.ci<-apply(pi.null[,-(1:2)],1,quantile,probs=c(0.25,0.75))

plot(r.mid, pi$pi, type="l")
lines(r.mid, null.ci[1,] , lty=2)
lines(r.mid, null.ci[2,] , lty=2)

}
}
\seealso{
Other get.pi: 
\code{\link{get.pi.bootstrap}()},
\code{\link{get.pi.ci}()},
\code{\link{get.pi.typed.bootstrap}()},
\code{\link{get.pi.typed.permute}()},
\code{\link{get.pi.typed}()},
\code{\link{get.pi}()}
}
\concept{get.pi}
