% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d-gev.R
\name{pgev.d}
\alias{pgev.d}
\title{d-GEV cumulative distribution function}
\usage{
pgev.d(q, mut, sigma0, xi, theta, eta, d, tau = 0, eta2 = NULL, ...)
}
\arguments{
\item{q}{vector of quantiles}

\item{mut, sigma0, xi}{numeric value, giving modified location, modified scale and shape parameter}

\item{theta}{numeric value, giving duration offset (defining curvature of the IDF curve)}

\item{eta}{numeric value, giving duration exponent (defining slope of the IDF curve)}

\item{d}{positive numeric value, giving duration}

\item{tau}{numeric value, giving intensity offset \eqn{\tau} (defining flattening of the IDF curve). Default: \eqn{\tau=0}.}

\item{eta2}{numeric value, giving a second duration exponent \eqn{\eta_2} (needed for multiscaling). Default: NULL, treated as \eqn{\eta_2=\eta}.}

\item{...}{additional parameters passed to \code{\link[evd]{pgev}}}
}
\value{
list containing vectors of probability values for given quantiles. 
The first element of the list are the probability values for the first given duration etc.
}
\description{
Cumulative probability distribution function of duration-dependent GEV distribution
}
\details{
The duration dependent GEV distribution is defined after 
[Koutsoyiannis et al., 1998]:
\deqn{G(x)= \exp[-\left( 1+\xi(x/\sigma(d)-\mu_t) \right)^{-1/\xi}] } 
with the duration dependent scale \eqn{\sigma(d)=\sigma_0/(d+\theta)^\eta} and 
modified location parameter \eqn{\mu_t=\mu/\sigma(d)}.

For details on the d-GEV and the parameter definitions, see \link{IDF-package}.
}
\examples{
x <- seq(4,20,0.1)
prob <- pgev.d(q=x,mut=4,sigma0=2,xi=0,theta=0.1,eta=0.1,d=1)
}
\seealso{
\code{\link{dgev.d}}, \code{\link{qgev.d}}, \code{\link{rgev.d}}
}
