% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_idea.R
\name{old_idea}
\alias{old_idea}
\title{Read "old" IDEA data files}
\usage{
old_idea(input)
}
\arguments{
\item{input}{a system path to the file containing the IDEA data.
The file extension has to be xls or xlsx.}
}
\value{
An object of class "IDEA_data" with three attributes :
\describe{
\item{metadata}{a named list containing the 17 metadata entries about the farm}
\item{dataset}{a tibble containing the score computed for the 53 indicators, 13 components and 3 dimensions}
\item{nodes}{a list of tibbles, one per property plus a global one, which all describe the qualitative evaluation}
}
}
\description{
This function is an alternative to the read/compute pipeline for older versions of IDEA data excel files.
}
\details{
This function is designed to import data from "old" IDEA data files. It will most probably work for IDEA4 excel files which are later than 2019-01-01. This actually works because this function focuses on indicators directly computed in the excel file rather than items. The potential drawbacks being that no information about items are collected and that some metadata may be missed.

Note : For the farm id metadata, the full First/Last name will be used if found.
}
\examples{
library(IDEATools)

## Importing from an old IDEA file
input <- "path_to_your_old_file.xlsx"
if(file.exists(input)) {
computed_data <- old_idea(input)
}
}
