% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICS_smoothing.R
\name{explicit_spline}
\alias{explicit_spline}
\title{The function computes the coefficients of the cubic polynomials as spline components of the clamped interpolating cubic spline of class \code{C^2} in its explicit form \code{S=B * gamma}.}
\usage{
explicit_spline(B, gamma)
}
\arguments{
\item{B}{a \code{4}-element array of \code{(n+1)x(n+4)} matrices, whereas element in \code{i}-th row and \code{j}-th column of \code{l}-th matrix contains coefficient by \code{x^{l-1}} of cubic polynomial that is in \code{i}-th row and \code{j}-th column of matrix \code{B} from spline's explicit form \code{S=B.gamma}.}

\item{gamma}{a vector of spline coefficients - function values and exterior-node derivatives that takes part in the explicit form \eqn{S=B.\gamma}.}
}
\value{
a matrix with four columns, whose \code{i}-th row contains the coefficients of the splines's \code{i}-th component.
}
\description{
The function computes the coefficients of the cubic polynomials as spline components of the clamped interpolating cubic spline of class \code{C^2} in its explicit form \code{S=B * gamma}.
}
\examples{
# See functions cics_explicit, cics_unif_explicit and the vignette.
}
