% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{pred_refit_range}
\alias{pred_refit_range}
\title{Get Refitted Predictive Models for a First-Fit Range of Panels}
\usage{
pred_refit_range(
  pred_first = NULL,
  gene_lengths = NULL,
  model = "T",
  biomarker = "TMB",
  marker_mut_types = c("NS", "I"),
  training_data = NULL,
  training_values = NULL,
  mutation_vector = NULL,
  t_s = NULL,
  max_panel_length = NULL
)
}
\arguments{
\item{pred_first}{(list)
A first-fit predictive model as produced by pred_first_fit().}

\item{gene_lengths}{(dataframe)
A dataframe of gene lengths (see example_maf_data$gene_lengths for format).}

\item{model}{(character)
A choice of "T", "OLM" or "Count" specifying how predictions should be made.}

\item{biomarker}{(character)
If "TMB" or "TIB", automatically defines marker_mut_types, otherwise this will
need to be specified separately.}

\item{marker_mut_types}{(character)
A vector specifying which mutation types groups determine the biomarker in question.}

\item{training_data}{(sparse matrix)
Training matrix, as produced by get_mutation_tables() (select train, val or test).}

\item{training_values}{(dataframe)
Training true values, as produced by get_biomarker_tables() (select train, val or test).}

\item{mutation_vector}{(numeric)
Optional vector specifying the values of the training matrix (training_data$matrix) in
vector rather than matrix form.}

\item{t_s}{(numeric)
Optional vector specifying the frequencies of different mutation types.}

\item{max_panel_length}{(numeric)
Upper bound for panels to fit refitted models to. Most useful for "OLM" and "Count"
model types.}
}
\value{
A list with three elements:
\itemize{
\item fit, a list including a sparse matrix 'beta' giving prediction weights for each
first-fit panel (one panel per column).
\item panel_genes, a sparse (logical) matrix giving the genes included in prediction
for each first-fit panel.
\item panel_lengths, a vector giving the length of each first-fit panel.
}
}
\description{
A function producing a refitted predictive model for each panel produced by usage of the function pred_first_fit(), by repeatedly applying the function pred_refit_panel().
}
\examples{
example_refit_range <- pred_refit_range(pred_first = example_first_pred_tmb,
  gene_lengths = example_maf_data$gene_lengths)
}
