% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-UserMinimaxFunctions.R
\name{robust}
\alias{robust}
\title{Robust D-Optimal Designs}
\usage{
robust(formula, predvars, parvars, family = gaussian(), lx, ux, iter, k,
  prob, parset, fimfunc = NULL, ICA.control = list(),
  sens.minimax.control = list(), initial = NULL,
  npar = dim(parset)[2], plot_3d = c("lattice", "rgl"), x = NULL)
}
\arguments{
\item{formula}{A nonlinear model \code{\link[stats]{formula}}.
A symbolic description of the model consists of predictors and the unknown model parameters.
Will be coerced to a \code{\link[stats]{formula}} if necessary.}

\item{predvars}{A vector of characters. Denotes the predictors in the \code{\link[stats]{formula}}.}

\item{parvars}{A vector of characters. Denotes the unknown parameters in the \code{\link[stats]{formula}}.}

\item{family}{A description of the response distribution and the link function to be used in the model.
This can be a family function, a call to a family function or a character string naming the family.
 Every family function has a link argument allowing to specify the link function to be applied on the response variable.
  If not specified, default links are used. For details see \code{\link[stats]{family}}.
   By default, a linear gaussian model \code{gaussian()} is applied.}

\item{lx}{Vector of lower bounds for the predictors. Should be in the same order as \code{predvars}.}

\item{ux}{Vector of upper bounds for the predictors. Should be in the same order as \code{predvars}.}

\item{iter}{Maximum number of iterations.}

\item{k}{Number of design points. Must be at least equal to the number of model parameters to avoid singularity of the FIM.}

\item{prob}{A vector of the probability measure \eqn{\pi} associated with each row of \code{parset}.}

\item{parset}{A matrix that provides the vector of initial estimates for the model parameters, i.e. support of \eqn{\pi}.
Every row is one vector  (\code{nrow(parset) == length(prob)}). See 'Details'.}

\item{fimfunc}{A function. Returns the FIM as a \code{matrix}. Required when \code{formula} is missing. See 'Details' of \code{\link{minimax}}.}

\item{ICA.control}{ICA control parameters. For details, see \code{\link{ICA.control}}.}

\item{sens.minimax.control}{Control parameters to verify the general equivalence theorem. For details, see the function \code{\link{sens.minimax.control}}.}

\item{initial}{A matrix of the  initial design points and weights that will be inserted into the initial solutions (countries) of the algorithm.
Every row is a design, i.e.  a concatenation of \code{x} and \code{w}. Will be coerced to a \code{matrix} if necessary.  See 'Details' of \code{\link{minimax}}.}

\item{npar}{Number of model parameters.  Used when \code{fimfunc} is given instead of \code{formula} to specify the number of model parameters.
If not given, the sensitivity plot may be shifted below the y-axis.
 When \code{NULL}, it is set to \code{dim(parset)[2]}.}

\item{plot_3d}{Which package should be used to plot the sensitivity (derivative) function for two-dimensional design space. Defaults to \code{"lattice"}.}

\item{x}{A vector of candidate design (support) points.
When is not set to \code{NULL} (default),
 the algorithm only finds the optimal weights for the candidate points in  \code{x}.
   Should be set when the user has a finite number of candidate design points  and the purpose
   is to find the optimal weight for each of them (when zero, they will be excluded from the design).
For design points with more than one dimension, see 'Details' of \code{\link{sensminimax}}.}
}
\value{
an object of class \code{minimax} that is a list including three sub-lists:
\describe{
  \item{\code{arg}}{A list of design and algorithm parameters.}
  \item{\code{evol}}{A list of length equal to the number of iterations that stores
   the information about the best design (design with least criterion value)
    of each iteration. \code{evol[[iter]]} contains:
    \tabular{lll}{
      \code{iter}                   \tab      \tab Iteration number.\cr
      \code{x}                      \tab      \tab Design points. \cr
      \code{w}                      \tab      \tab Design weights. \cr
      \code{min_cost}               \tab      \tab Value of the criterion for the best imperialist (design).  \cr
      \code{mean_cost}              \tab      \tab Mean of the criterion values of all the imperialists. \cr
      \code{sens}                   \tab      \tab An object of class \code{'sensminimax'}. See below. \cr
      \code{param}                  \tab      \tab Vector of parameters.\cr
    }
  }

  \item{\code{empires}}{A list of all the  empires of the last iteration.}
  \item{\code{alg}}{A list with following information:
    \tabular{lll}{
      \code{nfeval}           \tab      \tab Number of function evaluations.  It does not count the function evaluations from checking the general equivalence theorem.\cr
      \code{nlocal}           \tab      \tab Number of successful local searches. \cr
      \code{nrevol}           \tab      \tab Number of successful revolutions. \cr
      \code{nimprove}         \tab      \tab Number of successful movements toward the imperialists in the assimilation step. \cr
      \code{convergence}      \tab      \tab Stopped by \code{'maxiter'} or \code{'equivalence'}?\cr
    }
  }
}

The list \code{sens} contains information about the design verification by the general equivalence theorem. See \code{sensminimax} for more details.
It is given  every \code{ICA.control$checkfreq} iterations
and also the last iteration if   \code{ICA.control$checkfreq >= 0}. Otherwise, \code{NULL}.

 \code{param} is a vector of parameters that is the global minimum of
  the minimax criterion or the global maximum of the standardized maximin criterion over the parameter space, given  the current \code{x}, \code{w}.
}
\description{
Finds Robust designs or optimal  in-average designs for nonlinear models.
 It is useful when a set of different vectors of initial estimates
  along with a discrete probability measure
  are available for the unknown model parameters.
  It is a discrete version of \code{\link{bayes}}.
}
\details{
Let \eqn{\Theta} be a set of initial estimates for the unknown parameters.
A robust criterion is evaluated at the elements of \eqn{\Theta} weighted by a probability measure
\eqn{\pi} as follows:
\deqn{B(\xi, \pi) = \int_{\Theta}|M(\xi, \theta)|\pi(\theta) d\theta.}{
B(\xi, \Pi) = intergation over \Theta \Psi(\xi, \theta)\pi(\theta) d\theta.}
A robust design \eqn{\xi^*}{\xi*}   maximizes \eqn{B(\xi, \pi)} over the space of all designs.

 When the model is given via \code{formula},
  columns of \code{parset} must match the parameters introduced
  in \code{parvars}.
  Otherwise, when the model is introduced via \code{fimfunc},
  columns of \code{parset} must match the argument \code{param} in \code{fimfunc}.

 To verify the optimality of the output design by the general equivalence theorem,
 the user can either \code{plot} the results or set  \code{checkfreq} in \code{\link{ICA.control}}
 to \code{Inf}. In either way, the function \code{\link{sensrobust}} is called for verification.
One can also adjust the tuning parameters in \code{\link{ICA.control}} to set a stopping rule
based on the general equivalence theorem. See 'Examples' below.
}
\note{
When a continuous prior distribution for the unknown model parameters is available,  use \code{\link{bayes}}.
When only one initial estimates of the unknown model parameters is available (\eqn{\Theta} has only one element),  use  \code{\link{locally}}.
}
\examples{
# Finding a robust design for the two-parameter logistic model
# See how we set a stopping rule.
# The ELB is computed every checkfreq = 30 iterations
# The optimization stops when the ELB is larger than stoptol = .95
res1 <- robust(formula = ~1/(1 + exp(-b *(x - a))),
              predvars = c("x"), parvars = c("a", "b"),
              family = binomial(),
              lx = -5, ux = 5, prob = rep(1/4, 4),
              parset = matrix(c(0.5, 1.5, 0.5, 1.5, 4.0, 4.0, 5.0, 5.0), 4, 2),
              iter = 1, k =3,
              ICA.control = list(stop_rule = "equivalence",
                                 stoptol = .95, checkfreq = 30))

\dontrun{
res1 <- iterate(res1, 100)
# stops at iteration 51
}


\dontrun{
res1.1 <- robust(formula = ~1/(1 + exp(-b *(x - a))),
              predvars = c("x"), parvars = c("a", "b"),
              family = binomial(),
              lx = -5, ux = 5, prob = rep(1/4, 4),
              parset = matrix(c(0.5, 1.5, 0.5, 1.5, 4.0, 4.0, 5.0, 5.0), 4, 2),
              x = c(-3, 0, 3),
              iter = 150, k =3)
plot(res1.1)
# not optimal
}
}
\seealso{
\code{\link{bayes}} \code{\link{sensrobust}}
}
