% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_logisitic_1par}
\alias{FIM_logisitic_1par}
\title{Fisher information matrix for the one-parameter logistic model (1PL or Rasch model).}
\usage{
FIM_logisitic_1par(x, w, param)
}
\arguments{
\item{x}{vector of design points. In IRT \code{x} is the person ability parameter.}

\item{w}{vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.}

\item{param}{parameter \eqn{a}. In IRT, it is called difficulty parameter.}
}
\value{
Fisher information as a one by one matrix.
}
\description{
The mean of response variable is
 \deqn{f(x, a) = 1/(1 + \exp(-(x - a))).}{f(x, a) = \frac{1}{(1 + exp(-(x - a)))}.}
 This function returns Fisher information for the design \eqn{\xi} that is
 \deqn{M(\xi; a) = \sum_{i = 1}^kw_iM(x_i, a).}{M(\xi, a) = sum w_i M(x_i, a).}
  Here \eqn{M(x, a)}  is \eqn{g(x-a)}, where
 \eqn{g(z) = \frac{\exp(z)}{(1 + \exp(z))^2}}{g(z) = exp(z)/(1 + exp(z))^2}.
 denotes the standard logistic density.
}
\details{
The locally optimal design is a one point design with \eqn{x^* = a}{x* = a} and provides a value of
\eqn{M(\xi^*, a) =  1/4}{M(\xi*, a) =  1/4} for the information.
}
\references{
Grasshoff, U., Holling, H., & Schwabe, R. (2012). Optimal designs for the Rasch model. Psychometrika, 77(4), 710-723.
}
\seealso{
Other FIM: \code{\link{FIM_comp_inhibition}},
  \code{\link{FIM_emax_3par}}, \code{\link{FIM_exp_2par}},
  \code{\link{FIM_exp_3par}},
  \code{\link{FIM_logistic_4par}},
  \code{\link{FIM_logistic}}, \code{\link{FIM_loglin}},
  \code{\link{FIM_michaelis}},
  \code{\link{FIM_mixed_inhibition}},
  \code{\link{FIM_noncomp_inhibition}},
  \code{\link{FIM_power_logistic}},
  \code{\link{FIM_uncomp_inhibition}}
}

