% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA_mica.R
\name{mica}
\alias{mica}
\title{Imperialist Competitive Algorithm to find locally, minimax and standardized maximin D-optimal designs for nonlinear models}
\usage{
mica(fimfunc, lx, ux, lp, up, iter, k, control = list(),
  control_gosolnp = list(), type, initial = NULL, locally = NULL, ...)
}
\arguments{
\item{fimfunc}{FIM as a \code{function} or \code{character}.
As a \code{character}, it must be the name of the FIM function that are available,
 e.g. \code{as.character(substitute(FIM_logistic))}.
   As a \code{function} it must return the information matrix.  See "Details".}

\item{lx}{lower bound of the design space \eqn{\chi}.}

\item{ux}{upper bound of the design space \eqn{\chi}.}

\item{lp}{lower bound of the region of unceratinty \eqn{\Theta}. The order of the dimension is the same as the order of the parameters in the argument \code{param}of \code{fimfunc}.}

\item{up}{upper bound of the region of unceratinty \eqn{\Theta}. If \code{lp = up}, then \eqn{\Theta = \theta_0}{\Theta = \theta0} and the genearted design is locally D-optimal design. See "Examples".}

\item{iter}{maximum number of iterations.}

\item{k}{number of design (support) points. Must be larger than the number of model parameters \eqn{p} to avoid singularity of the FIM.}

\item{control}{a list of control parameters. See "Details".}

\item{control_gosolnp}{tuning parameters of function \code{\link[Rsolnp]{gosolnp}} for models that their locally optimal design do not have an
analytical solution and is find by \code{\link[Rsolnp]{gosolnp}}. Only required when \code{type} is set to \code{'standardized'}.
See "Details" of \code{\link{equivalence}}.}

\item{type}{a character strings; \code{"minimax"} for minimax optimal design, \code{"standardized"} for standardized maximin D-optimal design and \code{"locally"} for locally D-optimal design.
When \code{"locally"}, then  \code{lp} must be set equal to \code{up}.}

\item{initial}{a matrix of user intial countries or a vector of a country that will be inserted  into the initial countries of ICA. See "Details" .}

\item{locally}{locally a function that returns the value of determinant of FIM for
the locally D-optimal design, i.e.  \eqn{|M(\xi_{\bold{\theta}}, \bold{\theta})|}{|M(\xi_\theta, \theta)|}.
 Only required when \code{type} is set to \code{"standardized"}. See "Details" of \code{\link{equivalence}}.}

\item{...}{further arguments to be passed to the FIM function corresponding to \code{fimfunc}.
For power logisitc model when \code{fimfunc} is equal to \code{"FIM_power_logistic"},
 the value of  \code{s} must be given here.}
}
\value{
an object of class "ICA" that is a list contains another three lists:
\describe{
  \item{\code{arg}}{a list contains the arguments. Required for other methods.}
  \item{\code{evol}}{a list as length as the number of iterations to save the best design (best imperialist) in each iteration.
   \code{evol[[iter]]} contains:
    \tabular{lll}{
      \code{iter}                   \tab      \tab iteration. \cr
      \code{x}                      \tab      \tab design point. \cr
      \code{w}                      \tab      \tab design weight. \cr
      \code{min_cost}               \tab      \tab cost of the best imperialist. \cr
      \code{mean_cost}              \tab      \tab mean of costs of all imperialists. \cr
      \code{all_optima}             \tab      \tab all optima of the inner problem. \code{NA} for locally optimal design. \cr
      \code{all_optima_cost}        \tab      \tab cost of all optima of the inner problem. \code{NA} for locally optimal design. \cr
      \code{answering}              \tab      \tab answering set. \code{NA} for locally optimal design. \cr
      \code{answering_cost}         \tab      \tab cost of each element of answering set. \code{NA} for locally optimal design. \cr
      \code{mu}                     \tab      \tab found probability measure on answering set. \code{NA} for locally optimal design. \cr
      \code{max_deriv}              \tab      \tab maximum of the sensitivity function.  \cr
      \code{DLB}                    \tab      \tab D-efficiency lower bound. \cr
      \code{inner_param}            \tab      \tab inner parameter. See "Details".\cr
    }
  }

  \item{\code{empires}}{a list of empires.}
  \item{\code{alg}}{a list that contains the best solution with components:
    \tabular{lll}{
      \code{nfeval}           \tab      \tab number of function evaluations. (the call for checking equivalence theorem is not counted) \cr
      \code{nlocal}           \tab      \tab number of successful local search. \cr
      \code{nrevol}           \tab      \tab number of successful revolutions. \cr
      \code{nimprove}         \tab      \tab number of successful movements toward the imperialists in assimilation step. \cr
      \code{convergence}      \tab      \tab Why the algorithm has stopped?. \cr
    }
  }
}
The design in \code{best} is the same best imperialist generated in last iteration and  stored in \code{evol}.
}
\description{
Let \eqn{\Xi} be the space of all  approximate designs with
 \eqn{k} support points  at \eqn{x_1, x_2, ...,  x_k}{x1, x2, ...,  xk} from  design space \eqn{\chi} with
 corresponding weights  \eqn{w_1, . . . ,w_k}{w1, . . . ,wk}. Let \eqn{M(\xi, \theta)} be the Fisher information
 matrix (FIM) of a \eqn{k-}point design \eqn{\xi} and \eqn{\theta} be the vector of unknown parameters.
 A  minimax D-optimal design \eqn{\xi^*}{\xi*} is defined by
 \deqn{\xi^* = \arg \min_{\xi  \in \Xi}\max_{\theta \in \Theta} -\log|M(\xi, \theta)|.}{
 \xi* = arg min over \Xi {max over \Theta -log|M(\xi, \theta)|}.}
 Throughout, the terms ``inner problem'' and ``outer problem'' are used for optimization over \eqn{\Theta} and \eqn{\Xi}, respectively.\cr
 A standardized maximin D-optimal designs \eqn{\xi^*}{\xi*} is defined by
 \deqn{ \xi^* = \arg \max_{\xi \in \Xi}\inf_{\theta \in \Theta} \left[\left(\frac{|M(\xi, \theta)|}{|M(\xi_{\theta}, \theta)|}\right)^\frac{1}{p}\right],}{
  \xi* =  arg max over \Xi {inf over \Theta {|M(\xi, \theta)| / |M(\xi_\theta, \theta)|}^p},}
  where \eqn{p} is the number of model paramters and
   \eqn{\xi_{\theta}}{\xi_\theta}  is the locally D-optimal design with respect to \eqn{\theta}.\cr
A locally D-optimal designs \eqn{\xi^*}{\xi*} is defined by
\deqn{\xi^* = \arg \min_{\xi  \in \Xi} -\log|M(\xi, \theta_0)|.}{\xi* = arg min -log|M(\xi, \theta0)|,}
where the minization is over \eqn{\Xi} and \eqn{\theta_0}{\theta0} is the initial values for the unknown parameters.\cr
}
\details{
\code{fimfunc}  as a \code{function} must have three arguments:
  1) desig points \code{x},
  2) weights \code{w} and 3) model parameters \code{param}.
   The output should be of type \code{matrix}.
    Further parameters can be set, but should be passed by  \code{...} in \code{mica} (like parameter \eqn{s} in power logistic model).
    See "Examples".\cr
\code{fimfunc} as a character string  must be the name of the FIM functions defined in this package.
The implemented FIM functions are given as follows:
\tabular{lll}{
\code{fiumfunc = "FIM_logistic"}            \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_logistic}} \cr
\code{fiumfunc = "FIM_logistic_4par"}       \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_logistic_4par}} \cr
\code{fiumfunc = "FIM_power_logistic"}      \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_power_logistic}} \cr
\code{fiumfunc = "FIM_michaelis"}           \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_michaelis}} \cr
\code{fiumfunc = "FIM_emax_3par"}           \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_emax_3par}} \cr
\code{fiumfunc = "FIM_loglin"}              \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_loglin}} \cr
\code{fiumfunc = "FIM_exp_2par"}            \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_exp_2par}} \cr
\code{fiumfunc = "FIM_exp_3par"}            \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_exp_3par}} \cr
\code{fiumfunc = "FIM_comp_inhibition"}     \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_comp_inhibition}} \cr
\code{fiumfunc = "FIM_noncomp_inhibition"}  \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_noncomp_inhibition}} \cr
\code{fiumfunc = "FIM_uncomp_inhibition"}   \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_uncomp_inhibition}} \cr
\code{fiumfunc = "FIM_mixed_inhibition"}    \tab  equivalent to    \tab \code{fiumfunc = \link{FIM_mixed_inhibition}} \cr
}
Setting \code{fimfunc} as a character strings only results in using the internal defined \code{locally} for standardized maximin
optimal designs. See each information matrix for information about the parameters and the analytical locally optimal design (if available).




The \code{control} argument is a list that can supply any of the following components:
\describe{
  \item{\code{ncount}}{number of countries.  Defaults to \code{40}.}
  \item{\code{nimp}}{number of imperialists. Defaults to 10 percent of \code{ncount}.}
  \item{\code{assim_coeff}}{assimilation coefficient. Defaults to \code{4}.}
  \item{\code{revol_rate}}{revolution rate. Defaults to \code{0.3}}
  \item{\code{damp}}{damp ratio for revolution rate. Less than one. \code{revol_rate} is decreased by \code{damp} in every iteration. Defaults to \code{0.99}}
  \item{\code{zeta}}{a coefficient to find the 'total cost' of empires. Defaults to \code{0.1}.}
  \item{\code{uniting_threshold}}{if the distance between two imperialists is less than the product of the \code{uniting_threshold} and the largest distance in the search space, then ICA unites these two empires.
  defaults to \code{0.02}.}
  \item{\code{assim_strategy}}{a character strings denotes assimilation strategy; \code{PICA} for perturbed ICA and \code{ICA} for the original version. Defaults to \code{PICA}.}
  \item{\code{lsearch}}{logical. Perform a local search on imperialists in every iteration?  Defaults to \code{TRUE}.}
  \item{\code{l}}{positive integer. the number of local search for each imperialist. Defaults to \code{2}.}
  \item{\code{only_improve}}{logical. In assimilation step, only move the colonies if the new position is better than the current position. Defaults to \code{TRUE}.}
  \item{\code{stop_rule}}{a character string denotes stopping rule.
  When \code{"maxiter"}, then  ICA only stops when  reachs the maximum number of iterations.
  When \code{"one_empire"}, then ICA stops if either all empires collapsed and one empire remains or reachs the maximum number of iterations.
  When \code{"equivalence"}, then ICA stops if either the D-efficiency lower bound (\code{DLB}) of the current design is greater than \code{stoptol} or reachs the maximum number of iterations.}
  \item{\code{stoptol}}{numeric between \eqn{0} and \eqn{1}. The minimum \code{DLB} for the best current imperialist (best design) to stop the algorithm by equivalence theorem when \code{stop_rule = "equivalence"}. Defaults to \code{0.99}.}
  \item{\code{equivalence_every}}{a positive integer. Check and compute \code{DLB} in every \code{equivalence_every} iteration. Checking equivalence theorem in small intervals slows down the algorithm. Defaults to \code{200}.}
  \item{\code{equal_weight}}{logical; whether the points should have equal weights. Defaults to \code{FALSE}.}
  \item{\code{sym}}{logical. Whether the design is symmetric around a point. If \code{TRUE} then \code{sym_point} must be given. Defaults to \code{FALSE}}
  \item{\code{sym_point}}{a vector of the same length as \code{lx}. The point that the design is symmetric around.
   Must have the same length of \code{lx}. See "Examples".}
  \item{\code{inner_space}}{a character string denote the inner space. Can be  \code{"continuous"}, \code{"vertices"} or \code{"discrete"}. See below. Defaults to \code{"continuous"}.}
  \item{\code{param_set}}{a matrix denotes the fixed values for the parameters when \code{inner_space = "discrete"}. Each row of the matrix is one set (vector) of the values of the parameters,
   i.e.  \eqn{\theta_{01}}{\theta01} in the first row,  \eqn{\theta_{02}}{\theta02} in the second row and so on. The number of columns should be equal to \code{length(lp)}. See "Examples".}
  \item{\code{inner_maxeval}}{maximum number of function evaluations for the continuous inner problem. It comes from the tuning parameters of  \code{\link[nloptr]{directL}}.
   Its value should be large enough to not miss any global optima. It is only applicable for standardized maxinim and minimax
   optimal designs. Defaults to \code{600}.}
  \item{\code{plot_deriv}}{logical. Should derivative be plotted whenever equivalence theorem is checked? Defaults to \code{TRUE}.}
  \item{\code{plot_cost}}{logical. Should the evolution of ICA, i.e. mean cost of all imperialists and cost of the best imperialist, be plotted in every iteration? Defaults to \code{TRUE}; when \code{type = "locally"} is \code{FALSE}.}
  \item{\code{trace}}{logical. Should the best generated design (best imperialist) and corresponding algorithm parameters be printed in every iteration? Defauls to \code{TRUE}.}
  \item{\code{n.seg}}{a positive integer required when checking the equivalence theorem to construct the answering set.
  The number of initial starting points for local optimzer (\code{\link[stats]{optim}}) to find all minima of the criterion on parameters space is equal to \code{(n.seg + 1)^length(lp)}. See "Details". Defaults to \code{4}}
}


Each row of \code{intial} is one design, i.e. concatenation of
 \eqn{\bold{x} = (x_1,...x_k)}{x = (x1,...xk)} and \eqn{\bold{w} = (w_1,...,w_k)}{w = (w1,...,wk)}.
The number of columns of \code{initial} is equal to \eqn{k \times n + k}{k times  n + k},
 where \eqn{n} is the number of model explanatory variables. For multi-dimensional design space, \eqn{\bold{x}} must be
 given dimension by dimension. See description of argument \code{x} in \code{\link{equivalence}}.\cr



In \code{control}, if \code{inner_space = "continuous"}, then the inner problem is an optimization over
 \eqn{\Theta =} (\code{lp}, \code{up}).
 If \code{inner_space = "discrete"}, then the inner problem is a discrete optimization problem over
  a set of initial values for the parameters, i.e.
   \eqn{\Theta = \{\theta_{01}, \theta_{02},...\}}{\Theta = {\theta01, \theta02, ....}}.
 In this case, the set of initial parameters should be given through \code{param_set}.
 If \code{inner_space = "vertices"} then the set of intial parameters are the vertices of \eqn{\Theta}. This should be set when the user is certain that the D-criterion is convex with respect to the parameter space for every given design.
 Please note that regardless of what \code{inner_space} is, checking the equivalence theorem  is done on continuous parameter space \eqn{\Theta}. See "Examples" on how to use this option. \cr



For large parameter space or complex models it is important to increase \code{ncount},
 \code{inner_maxeval} and \code{n.seg} (for checking the equivalence theorem).\cr

Please note that the speed of \code{mica} highly depends on the \code{inner_maxeval} parameter
 in \code{control} when \code{inner_space = "continuous"}.
\code{equivalence_every} and \code{l} in local search are the other factors that impact the CPU time.\cr

From Section "Value",  note that \code{all_optima}, \code{all_optima_cost}, \code{answering}, \code{answering_cost},
   \code{mu},  \code{max_deriv} and \code{DLB} are  \code{NA} when the
      equivalence theorem was not requested for that iteration by \code{equivalence_every} in control.
       For example, if \code{equivalence_every = 100}, then  the equivalence theorem is only check for
       best designs in iteration \eqn{100}, \eqn{200}, \eqn{300} and so on.\cr
From Section "Value", \code{inner_param}  is equal to \eqn{\arg \max_{\theta \in \Theta} -\log|M(\xi, \theta)|,}{arg  max -log|M(\xi, \theta)|,} for minimax and
       \eqn{  \arg \inf_{\theta \in \Theta} \left[\left(\frac{|M(\xi, \theta)|}{|M(\xi_{\theta}, \theta)|}\right)^\frac{1}{p}\right],}{ =  arg inf {|M(\xi, \theta)| / |M(\xi_\theta, \theta)|}^p,}
       for standardized maximin D-optimal designs.
}
\examples{
#######################################################################
## some examples for exponential model
\dontrun{
# finding standardized maximin D-optimal design
res <- mica(fimfunc = "FIM_exp_2par", lx = 0, ux = 1, lp = c(1, 1), up = c(1, 5),
    iter = 100, k = 3, type = "standardized", control = list(seed = 215))
res <- iterate(res, 10)
plot(res)
# finding minimax D-optimal design
mica(fimfunc = "FIM_exp_2par", lx = 0, ux = 1, lp = c(1, 1), up = c(1, 5),
    iter = 100, k = 3, type = "minimax", control = list(seed = 215))
}
# finding locally D-optimal design. Please note that  'lp' and 'up' are equal
mica(fimfunc = "FIM_exp_2par", lx = 0, ux = 1, lp = c(2, 3), up = c(2, 3),
    iter = 40, k = 2, type = "locally", control = list(seed = 215))
# locally D-optimal design is x1 = lx, x2 = 1/lp[2]

# requesting an equally-weighted design, i.e w_1 = w_2 = ... w_k
res_loc <-mica(fimfunc = "FIM_exp_2par", lx = 0, ux = 1, lp = c(2, 3), up = c(2, 3),
              iter = 40, k = 2, type = "locally",
               control = list(seed = 215, equal_weight = TRUE))
\dontrun{
res_loc <- iterate(res_loc, 10) ## update the result
plot(res_loc)
# using symetric option for the logisitic model
mica(fimfunc = "FIM_logistic", lx = -5, ux = 5, lp = c(0, 1), up = c(3.5 , 1.25),
    iter = 100, k = 5, control = list(rseed = 215, sym = TRUE,
     sym_point = (0 + 3.5)/2),type = "minimax")
#######################################################################
# 2PL model
mica(fimfunc = "FIM_logistic", lx = -5, ux = 5, lp = c(-1, 1), up = c(1 , 2),
    iter = 100, k = 3, control = list(rseed = 215), type = "minimax")

# an example on how to supply 'fimfunc' with a function
logistic_fim <- function(x, w, param){
 a <- param[1]
 b <- param[2]
 constant <- 1/(1 + exp(-b * (x - a)))
 constant <- constant * (1 - constant)
 A <-  sum(w * b^2 * constant)
 B <- sum(-w * b * (x - a) * constant)
 C <- sum(w * ((x -a)^2) * constant)
 mat <- matrix(c(A, B, B, C), 2, 2)
 return(mat)
}

mica(fimfunc = logistic_fim, lx = -5, ux = 5, lp = c(-1, 1), up = c(1 , 2),
    iter = 100, k = 3,  control = list(rseed = 215), type = "minimax")
     ## is the same when 'fimfunc = "FIM_logistic'

mica(fimfunc = logistic_fim, lx = -5, ux = 5, lp = c(-1, 1), up = c(-1 , 1),
    iter = 100, k = 3, control = list(rseed = 215), type = "locally")
#######################################################################

#######################################################################
## how to use inner_space option in control list

#### Enzyme kinetic models. examples for3D plots
mica(fimfunc = "FIM_comp_inhibition", lx = c(0, 0), ux = c(30, 60),
    lp = c(7, 4, 2), up = c(7, 5, 3), k =3, type = "standardized",
    iter = 300, control = list(rseed = 215, inner_maxit = 300,
                               stop_rule = "equivalence",
                               countries = 100, nimperialists = 10))

## setting the parameter space as only the points on the vertices
mica(fimfunc = "FIM_comp_inhibition", lx = c(0, 0), ux = c(30, 60),
    lp = c(7, 4, 2), up = c(7, 5, 3), k =3, type = "standardized",
    iter = 300, control = list(rseed = 215, inner_space = "vertices",
                               stop_rule = "equivalence",
                               countries = 100, nimperialists = 10))

## every row is one of the vertices of Theta
param_set <- matrix(c(7, 4, 2, 7, 5, 2, 7, 4, 3, 7, 5, 3),
                   ncol = 3, nrow = 4, byrow = TRUE)
res <-mica(fimfunc = "FIM_comp_inhibition", lx = c(0, 0), ux = c(30, 60),
          lp = c(7, 4, 2), up = c(7, 5, 3), k =3, type = "standardized",
          iter = 300, control = list(rseed = 215,inner_space = "discrete",
                                     stop_rule = "equivalence", countries = 100,
                                     nimperialists = 10, param_set = param_set))


#######################################################################

#######################################################################
## optimal designs for the 1Pl model
mica(fimfunc = "FIM_logistic_1par", lx = 0, ux = 5,
     lp = 2, up = 2, k = 3, iter = 100, type = "locally")

lx <- -.5
ux <- .5
ux - lx <= 2 * log(2 + sqrt(3))
mica(fimfunc = "FIM_logistic_1par", lx = lx, ux = ux,
    lp = -1, up = 1, k = 1, iter = 10,
    type = "standardized")



lx <- -2
ux <- 2
ux - lx <= 2 * log(2 + sqrt(3))
mica(fimfunc = "FIM_logistic_1par", lx = lx, ux = ux,
    lp = -1, up = 1, k = 1, iter = 10,
   type = "standardized")
#######################################################################

}

}
\references{
Masoudi, E., Holling, H., & Wong, W. K.  (in press). Application of imperialist competitive algorithm to find minimax and standardized maximin optimal designs. Computational Statistics & Data Analysis.
}

