% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{SplitOneVCF}
\alias{SplitOneVCF}
\title{Split a VCF into SBS, DBS, and ID VCFs, plus a list of other mutations}
\usage{
SplitOneVCF(vcf.df, max.vaf.diff = 0.02, name.of.VCF = NULL)
}
\arguments{
\item{vcf.df}{An in-memory data.frame representing a VCF, including
VAFs, which are added by \code{\link{ReadVCF}}.}

\item{max.vaf.diff}{The maximum difference of VAF, default value is 0.02. If
the absolute difference of VAFs for adjacent SBSs is bigger than
\code{max.vaf.diff}, then these adjacent SBSs are likely to be "merely"
asynchronous single base mutations, opposed to a simultaneous doublet
mutation or variants involving more than two consecutive bases.}

\item{name.of.VCF}{Name of the VCF file.}
}
\value{
A list with 3 in-memory VCFs and discarded variants that were not
  incorporated into the first 3 VCFs:

 * \code{SBS}: VCF with only single base substitutions.

 * \code{DBS}: VCF with only doublet base substitutions
  as called by Mutect.

 * \code{ID}: VCF with only small insertions and deletions.

 * \code{discarded.variants}: \strong{Non-NULL only if} there are variants
 that were excluded from the analysis. See the added extra column
 \code{discarded.reason} for more details.
 @md
}
\description{
Split a VCF into SBS, DBS, and ID VCFs, plus a list of other mutations
}
\keyword{internal}
