% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotCatalog}
\alias{PlotCatalog}
\title{Plot \strong{one} spectrum or signature}
\usage{
PlotCatalog(
  catalog,
  plot.SBS12 = NULL,
  cex = NULL,
  grid = NULL,
  upper = NULL,
  xlabels = NULL,
  ylim = NULL
)
}
\arguments{
\item{catalog}{A catalog as defined in \code{\link{ICAMS}} with attributes added.
See \code{\link{as.catalog}} for more details.}

\item{plot.SBS12}{Only meaningful for class \code{SBS192Catalog}; if \code{TRUE},
generate an abbreviated plot of only SBS without context, i.e. 
C>A, C>G, C>T, T>A, T>C, T>G each on transcribed and untranscribed strands,
rather than SBS in trinucleotide context, e.g.
ACA > AAA, ACA > AGA, ..., TCT > TAT, ...}

\item{cex}{Has the usual meaning. Taken from \code{par("cex")} by default.
Only implemented for SBS96Catalog, SBS192Catalog and DBS144Catalog.}

\item{grid}{A logical value indicating whether to draw grid lines. Only
implemented for SBS96Catalog.}

\item{upper}{A logical value indicating whether to draw horizontal lines and
the names of major mutation class on top of graph. Only implemented for
SBS96Catalog.}

\item{xlabels}{A logical value indicating whether to draw x axis labels. Only
implemented for \code{SBS96Catalog}. If \code{FALSE} then plot x axis tick marks;
set \code{par(tck = 0)} to suppress.}

\item{ylim}{Has the usual meaning. Only implemented for SBS96Catalog and
IndelCatalog.}
}
\value{
An \strong{invisible} list whose first element is a logic value
  indicating whether the plot is successful. For \code{SBS96Catalog},
  \code{SBS192Catalog}, \code{DBS78Catalog}, \code{DBS144Catalog} and
  \code{IndelCatalog}, the list will have a second element, which is a
  numeric vector giving the coordinates of all the bar midpoints drawn,
  useful for adding to the graph. For \strong{SBS192Catalog} with "counts"
  catalog.type and non-NULL abundance and \code{plot.SBS12 = TRUE}, the list
  will have an additional element which is a list containing the strand bias
  statistics.
}
\description{
Plot the spectrum of \strong{one} sample or plot \strong{one} signature. The
type of graph is based on one attribute("catalog.type") of the input catalog.
You can first use \code{\link{TransformCatalog}} to get different types of
catalog and then do the plotting.
}
\note{
The sizes of repeats involved in deletions range from 0 to 5+ in the
  mutational-spectra and signature catalog rownames, but for plotting and
  end-user documentation deletion repeat sizes range from 1 to 6+.
}
\section{Comments}{
 For \strong{SBS192Catalog} with "counts" catalog.type and
  non-NULL abundance and \code{plot.SBS12 = TRUE}, the strand bias statistics
  are Benjamini-Hochberg q-values based on two-sided binomial tests of the
  mutation counts on the transcribed and untranscribed strands relative to
  the actual abundances of C and T on the transcribed strand. On the SBS12
  plot, asterisks indicate q-values as follows *, \eqn{Q<0.05}; **,
  \eqn{Q<0.01}; ***, \eqn{Q<0.001}.
}

\examples{
file <- system.file("extdata",
                    "strelka.regress.cat.sbs.96.csv",
                    package = "ICAMS")
catSBS96 <- ReadCatalog(file)
colnames(catSBS96) <- "sample"
PlotCatalog(catSBS96)
}
