% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadStrelkaSBSVCFs}
\alias{ReadStrelkaSBSVCFs}
\title{Read Strelka SBS (single base substitutions) VCF files.}
\usage{
ReadStrelkaSBSVCFs(files, names.of.VCFs = NULL)
}
\arguments{
\item{files}{Character vector of file paths to the VCF files.}

\item{names.of.VCFs}{Character vector of names of the VCF files. The order
of names in \code{names.of.VCFs} should match the order of VCF file paths
in \code{files}. If \code{NULL}(default), this function will remove all of
the path up to and including the last path separator (if any) and file
paths without extensions (and the leading dot) will be used as the names of
the VCF files.}
}
\value{
A list of lists which contain information about VCFs from
  \code{files}. Each list has two objects. The first object is a data frame
  storing data lines of a VCF file with VAFs added. The second object
  is a number indicating the number of rows in the first object.
}
\description{
Read Strelka SBS (single base substitutions) VCF files.
}
\keyword{internal}
