% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{CreateOneColSBSMatrix}
\alias{CreateOneColSBSMatrix}
\title{Create the matrix an SBS catalog for *one* sample from an in-memory VCF.}
\usage{
CreateOneColSBSMatrix(vcf, sample.id = "count")
}
\arguments{
\item{vcf}{An in-memory VCF file annotated with sequence context and
transcript information by function \code{\link{AnnotateSBSVCF}}. It must
*not* contain indels and must *not* contain DBS (double base
substitutions), or triplet base substitutions etc., even if encoded as
neighboring SBS.}

\item{sample.id}{Usually the sample id, but defaults to "count".}
}
\value{
A list of three 1-column matrices with the names
\code{catSBS96}, \code{catSBS192}, \code{catSBS1536}.
 If trans.ranges is NULL, \code{catSBS192} is not generated.
 Do not rely on the order of elements in the list.
}
\description{
Create the matrix an SBS catalog for *one* sample from an in-memory VCF.
}
\note{
catSBS192 only contains mutations in transcribed regions.
}
\keyword{internal}
