% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{TransformCatalog}
\alias{TransformCatalog}
\title{Transform between counts and density spectrum catalogs
and counts and density signature catalogs.}
\usage{
TransformCatalog(catalog, target.ref.genome = NULL,
  target.region = NULL, target.catalog.type = NULL,
  target.abundance = NULL)
}
\arguments{
\item{catalog}{An SBS or DBS catalog as described in \code{\link{ICAMS}};
must \strong{not} be an ID (indel) catalog.}

\item{target.ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}. If \code{NULL}, then defaults to the
\code{ref.genome} attribute of \code{catalog}.}

\item{target.region}{A \code{region} argument; see \code{\link{as.catalog}}
and \code{\link{ICAMS}}. If \code{NULL}, then defaults to the
  \code{region} attribute of \code{catalog}.}

\item{target.catalog.type}{A character string acting as a catalog type
identifier, one of "counts", "density", "counts.signature",
"density.signature"; see \code{\link{as.catalog}}. If \code{NULL}, then defaults to the
\code{catalog.type} attribute of \code{catalog}.}

\item{target.abundance}{A vector of counts different
source K-mer sequences for mutations. See
\code{\link{all.abundance}}. If \code{NULL},
then the function attempt to infer the \code{target.abundace}
from the class of \code{catalog} and the values of the
\code{target.ref.genome}, \code{target.region}, and
\code{target.catalog.type}. It is an error if the inferred
abundance is different from an non-\code{NULL} 
\code{target.abundance}.}
}
\value{
A catalog as defined in \code{\link{ICAMS}}.
}
\description{
Transform between counts and density spectrum catalogs
and counts and density signature catalogs.
}
\details{
Only the following transformations are legal:

\enumerate{

\item \code{counts -> counts} (used to transform
   between the source abundance and \code{target.abundance})

\item \code{counts -> density}

\item \code{counts -> (counts.signature, density.signature)}

\item \code{density -> counts} (the semantics are to
infer the genome-wide or exome-wide counts based on the
densities)

\item \code{density -> density} (a null operation, generates
a warning)

\item \code{density -> (counts.signature, density.signature)}

\item \code{counts.signature -> counts.signature} (used to transform
   between the source abundance and \code{target.abundance})

\item \code{counts.signature -> density.signature}

\item \code{counts.signature -> (counts, density)} (generates an error)

\item \code{density.signature -> density.signature} (a null operation,
generates a warning)

\item \code{density.signature -> counts.signature}

\item \code{density.signature -> (counts, density)} (generates an error)

}
}
\examples{
file <- system.file("extdata",
                    "strelka.regress.cat.sbs.96.csv",
                    package = "ICAMS")
catSBS96.counts <- ReadCatalog(file, ref.genome = "hg19", 
                               region = "genome",
                               catalog.type = "counts")
catSBS96.density <- TransformCatalog(catSBS96.counts,
                                     target.ref.genome = "hg19",
                                     target.region = "genome",
                                     target.catalog.type = "density")
}
