% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{AnnotateSBSVCF}
\alias{AnnotateSBSVCF}
\title{Add sequence context and transcript information to an in-memory SBS VCF.}
\usage{
AnnotateSBSVCF(SBS.vcf, ref.genome, trans.ranges = NULL)
}
\arguments{
\item{SBS.vcf}{An in-memory SBS VCF as a \code{data.frame}.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{trans.ranges}{a \code{\link[data.table]{data.table}} which contains
transcript range and strand information. Please refer to
\code{\link{TranscriptRanges}} for more details. 
If \code{is.null(trans.ranges)} do not add transcript range
information.}
}
\value{
An in-memory SBS VCF as a \code{data.table}. This has been annotated
  with the sequence context (column name \code{seq.21bases}) and with
  transcript information in the form of a gene symbol (e.g. \code{"TP53"})
  and transcript strand. This information is in the columns
  \code{trans.start.pos}, \code{trans.end.pos} , \code{trans.strand},
  \code{trans.Ensembl.gene.ID} and \code{trans.gene.symbol} in the output.
  These columns are not added if \code{is.null(trans.ranges)}.
}
\description{
Add sequence context and transcript information to an in-memory SBS VCF.
}
\examples{
file <- c(system.file("extdata",
                      "Strelka.SBS.GRCh37.vcf",
                      package = "ICAMS"))
list.of.vcfs <- ReadAndSplitStrelkaSBSVCFs(file)
SBS.vcf <- list.of.vcfs$SBS.vcfs[[1]]             
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  annotated.SBS.vcf <- AnnotateSBSVCF(SBS.vcf, ref.genome = "hg19",
                                      trans.ranges = trans.ranges.GRCh37)}
}
