% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooTransp.R
\name{SigmaT}
\alias{SigmaT}
\title{Surface Tension, Function of Temperature}
\usage{
SigmaT(T)
}
\arguments{
\item{T}{Temperature [ K ]}
}
\value{
The Surface Tension: Sigma [ mN m-1 ] and an Error Message (if an error occur)
}
\description{
The function \code{SigmaT(T)} computes the Surface Tension [ mN m-1 ]
     for a given T [K], returning the calculated Surface Tension and an 
     error message, if an error occur. \link{errorCodes}
}
\details{
This function calls a Fortran DLL that solves the equations developed by
    the International Association for the Properties of Water and Steam, valid from 
    the triple point to the critical temperature [ 273.13K to 647.096K].
     \url{http://www.iapws.org/relguide/Surf-H2O.html}
}
\examples{
T <- 500.
Sig <- SigmaT(T)
Sig

}
