% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IncompleteGamma.R
\name{IncGamma}
\alias{IncGamma}
\title{Incomplete Gamma function of a matrix argument}
\usage{
IncGamma(m, a, x)
}
\arguments{
\item{m}{truncation weight of the summation, a positive integer}

\item{a}{real or complex parameter with \code{Re(a)>(p-1)/2}, where
\code{p} is the dimension (the order of the matrix)}

\item{x}{either a real or complex square matrix,
or a numeric or complex vector, the eigenvalues of the matrix}
}
\value{
A real or complex number.
}
\description{
Evaluates the incomplete Gamma function of a matrix argument.
}
\note{
This function is usually defined
for a symmetric real matrix or a Hermitian complex matrix.
}
\examples{
# for a scalar x, this is the incomplete Gamma function:
a <- 2
x <- 1.5
IncGamma(m = 15, a, x)
gsl::gamma_inc_P(a, x)
pgamma(x, shape = a, rate = 1)
}
\references{
A. K. Gupta and D. K. Nagar.
\emph{Matrix variate distributions}. Chapman and Hall, 1999.
}
