% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.HydePosterior.R
\name{print.HydePosterior}
\alias{print.HydePosterior}
\title{Print a Hyde Posterior Distribution Object}
\usage{
\method{print}{HydePosterior}(x, ...)
}
\arguments{
\item{x}{a \code{HydePosterior} object}

\item{...}{additional arguments to be passed to print methods.  Currently 
none in use.}
}
\description{
Prints a brief description of a HydePosterior object.
}
\details{
Prints the number of posterior distributions, chains, and 
  iterations, as well as the observed values.
}
\examples{
data(PE, package="HydeNet")
Net <- HydeNetwork(~ wells + 
                     pe | wells + 
                     d.dimer | pregnant*pe + 
                     angio | pe + 
                     treat | d.dimer*angio + 
                     death | pe*treat,
                     data = PE) 

Net <- setDecisionNodes(Net, treat)  
                 
compiledNet <- compileJagsModel(Net, n.chains=5)

#* Generate the posterior distribution for the model (but not the 
#* decision model)
Posterior <- HydePosterior(compiledNet, 
                           variable.names = c("d.dimer", "death"), 
                           n.iter = 1000)
Posterior

#* Generate the posterior for the decision model
Decision <- compileDecisionModel(Net, n.chains=5)
Posterior_decision <- HydePosterior(Decision, 
                                    variable.names = c("d.dimer", "death"), 
                                    n.iter = 1000)

}
\author{
Jarrod Dalton and Benjamin Nutter
}

