% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compileJagsModel.R
\name{compileJagsModel}
\alias{compileJagsModel}
\title{Compile Jags Model from a Hyde Network}
\usage{
compileJagsModel(network, data = NULL, ...)
}
\arguments{
\item{network}{An object of class \code{HydeNetwork}}

\item{data}{A list of data values to be observed in the nodes.  It is
passed to the \code{data} argument of \code{rjags::jags}.  Alternatively,
a data frame representing a policy matrix may be provided to compile
multiple JAGS models.}

\item{...}{Additional arguments to be passed to \code{jags.model}}
}
\value{
Returns a \code{compiledHydeNetwork} object.  The \code{jags} element
  of this object is suitable to pass to \code{coda.samples}.  Otherwise, 
  the primary function of the object is plotting the network with 
  observed data shown.
}
\description{
Generates the JAGS code from the Hyde network and uses it to 
  create an object representing a Bayesian graphical model.
}
\details{
\code{compileJagsModel} is a partial wrapper for 
  \code{jags.model}. Running \code{compileJagsModel(network)} is 
  equivalent to running \code{jags.model(textConnection(writeNetworkModel(network)))}.
}
\examples{
data(PE, package="HydeNet")
Net <- HydeNetwork(~ wells + 
                     pe | wells + 
                     d.dimer | pregnant*pe + 
                     angio | pe + 
                     treat | d.dimer*angio + 
                     death | pe*treat,
                     data = PE) 
  
                 
compiledNet <- compileJagsModel(Net, n.chains=5)

#* Generate the posterior distribution
Posterior <- HydePosterior(compiledNet, 
                           variable.names = c("d.dimer", "death"), 
                           n.iter = 1000)
Posterior

#* For a single model (ie, not a decision model), the user may choose to 
#* use the \\code{rjags} function \\code{coda.samples}.
#* However, this does not have a succinct print method
library(rjags)
s <- coda.samples(compiledNet$jags, 
                  variable.names = c("d.dimer", "death"), 
                  n.iter=1000)
                
}
\author{
Benjamin Nutter
}
\seealso{
\code{jags.model}
}

