% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/setNode.R
\name{setNode}
\alias{fromData}
\alias{fromFormula}
\alias{setNode}
\title{Set Node Relationships}
\usage{
setNode(network, node, nodeType, nodeFitter, nodeFormula, fitterArgs = list(),
  decision = "current", utility = "current",
  fromData = !is.null(network$data), ..., nodeData = NULL,
  factorLevels = NULL, validate = TRUE,
  fitModel = getOption("Hyde_fitModel"))

fromData()

fromFormula()
}
\arguments{
\item{network}{A \code{HydeNetwork}.}

\item{node}{A node within \code{network}.  This does not have to be quoted.}

\item{nodeType}{a valid distribution function from JAGS.  See the data set
in \code{data(jagsDists)} for a complete list.}

\item{nodeFitter}{the fitting function, such as \code{lm} or \code{glm}.  This
will probably only be needed when \code{fromData = TRUE}.}

\item{nodeFormula}{A formula object specifying the relationship between a
node and its parents.  It must use as a term every parent of \code{node}.}

\item{fitterArgs}{Additional arguments to be passed to \code{fitter}.  This does not
yet have any effect as I haven't yet decided out where to store this and
how to implement the fitting.}

\item{decision}{A value of either \code{"current"} or a logical value.
If \code{"current"}, the current value of the setting is retained.  This allows
decision nodes set by \code{setDecisionNode} to retain the classification as a
decision node if \code{setNode} is run after \code{setDecisionNode}.
If \code{TRUE}, the node will be considered a
decision node in \code{compileDecisionNetwork}.  This is only a valid
option when the node is of type \code{"dbern"} or \code{"dcat"}. Note: if any
character value other than \code{"current"} is given, \code{setNode} will assume
you intended \code{"current"}.}

\item{utility}{A value of either \code{"current"} or a logical value.
If \code{"current"}, the current value of the setting is retained.  This allows
utility nodes set by \code{setUtilityNode} to retain the classification as a
utility node if \code{setNode} is run after \code{setUtilityNode}.
If \code{TRUE}, the node will be considered a
utility node.  This is only a valid option when the node is of type
\code{"determ"} and it has no children.
Note: if any
character value other than \code{"current"} is given, \code{setNode} will assume
you intended \code{"current"}.}

\item{fromData}{Logical.  Determines if a node's relationship is calculated
from the data object in \code{network}.  Defaults to \code{TRUE} whenever
\code{network} has a data object.}

\item{...}{parameters to be passed to the JAGS distribution function.  Each parameter
in the distribution function must be named.  For
example, the parameters to pass to \code{dnorm} would be \code{mu='', tau=''}.
The required parameters can be looked up using the
\code{expectedParameters} function.  If parameters are to be estimated
from the data, the functions \code{fromData} and \code{fromFormula} may
be used as placeholders.}

\item{nodeData}{A data frame with the appropriate data to fit the model for the node.
Data passed in this argument are applied only to this specific node.  No checks are
performed to ensure that all of the appropriate variables (the node and its parents)
are included.}

\item{factorLevels}{A character vector used to specify the levels of factors
when data are not provided for a node.  The order of factors follows the
order provided by the user.  This argument is only used when the node type
is either \code{dcat} or \code{dbern}, the node Fitter is not \code{cpt},
\code{nodeData} is \code{NULL}, and no variable for the node exists in
the network's \code{data} element.  If any of those conditions is not met,
\code{factorLevels} is ignored.  This proves particularly important when
data are specified in order to prevent a user specification from conflicting
with expected factors across nodes.}

\item{validate}{Logical.  Toggles validation of parameters given in \code{...}.
When passing raw JAGS code (ie, character strings), this will be ignored
(with a message),
as the validation is applicable to numerical/formula values.}

\item{fitModel}{Logical. Toggles if the model is fit within the function call.
  This may be set globally using \code{options('Hyde_fitModel')}.  See Details
  for more about when to use this option.}
}
\description{
The relationship between a node and its parents must be defined
  before the appropriate JAGS model statement can be constructed.
  \code{setNode} is the utility by which a user can define the distribution
  of the node and its relationship to its parents (usually through a model
  of some sort).
}
\details{
The functions \code{fromFormula()} and \code{fromData()} help to control
  how \code{Hyde} determines the values of parameters passed to JAGS.  If the
  parameters passed in \code{params} argument are to be calculated from the
  data or inferred from the formula, these functions may be used as placeholders
  instead of writing JAGS code in the \code{params} argument.

  By default, \code{options(Hyde_fitModel=FALSE)}.  This prevents \code{setNode}
  from fitting any models.  Instead, the fitting is delayed until the user
  calls \code{writeJagsModel} and all of the models are fit at the same time.
  When using large data sets that may require time to run, it may be better to
  leave this option \code{FALSE} so that the models can all be compiled together
  (especially if you are working interactively).  Using \code{fitModel=TRUE}
  will cause the model to be fit and the JAGS code for the parameters to be
  stored in the \code{nodeParams} attribute.
}
\section{Validation}{

The validation of parameters is performed by comparing the values provided with
the limits defined in the \code{jagsDists$paramLogic} variable. (look at
\code{data(jagsDists, data='HydeNet')}.  For most node types, validation will
be peformed for numeric variables.  For deterministic variables, the validation
will only check that the parameter definition is a formula.

It is possible to pass character strings as definitions, but when this is done,
\code{HydeNet} assumes you are passing JAGS code.  Unfortunately, \code{HydeNet}
doesn't have to capability to validate JAGS code, so if there is an error in
the character string definition, it won't show up until you try to compile the
network.  If you pass a character string as a parameter and leave
\code{validate = TRUE}, a message will be printed to indicate that validation
is being ignored.  This message can be avoided by using \code{validate = FALSE}

The two exceptions to this rule are when you pass \code{fromFormula()} and
\code{fromData()} as the parameter definition.  These will skip the validation
without warning, since the definition will be built by \code{HydeNet} and be
proper JAGS code (barring any bugs, of course).
}
\examples{
data(PE, package="HydeNet")
Net <- HydeNetwork(~ wells +
                     pe | wells +
                     d.dimer | pregnant*pe +
                     angio | pe +
                     treat | d.dimer*angio +
                     death | pe*treat,
                     data = PE)
print(Net, d.dimer)

#* Manually change the precision
Net <- setNode(Net, d.dimer, nodeType='dnorm', mu=fromFormula(), tau=1/2.65,
                  nodeFormula = d.dimer ~ pregnant * pe,
                  nodeFitter='lm')
print(Net, d.dimer)
}
\author{
Jarrod Dalton and Benjamin Nutter
}

