% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{GOF_volumetric_efficiency}
\alias{GOF_volumetric_efficiency}
\title{Calculate Volumetric Efficiency}
\usage{
GOF_volumetric_efficiency(mod, obs, na.rm = TRUE)
}
\arguments{
\item{mod}{'numeric' vector. Modeled or simulated values. Must be same length as \code{obs}.}

\item{obs}{'numeric' vector. Observed or comparison values. Must be same length as \code{mod}.}

\item{na.rm}{'boolean' \code{TRUE} or \code{FALSE}. Should \code{NA} values be removed before computing. If any
\code{NA} values are present in \code{mod} or \code{obs}, the \emph{i}th position from each will be removed before
calculating. If \code{NA} values are present and \code{na.rm = FALSE}, then function will return \code{NA}.
Default is \code{TRUE}.}
}
\value{
Value of computed Volumetric efficiency.
}
\description{
Calculate Volumetric efficiency (VE) between modeled (simulated) and observed
values. VE is defined as the fraction of water delivered at the proper time
(Criss and Winston, 2008).
}
\details{
Volumetric efficiency was proposed in order to circumvent some problems associated to the
Nash--Sutcliffe efficiency. It ranges from \code{0} to \code{1} and represents the fraction of water
delivered at the proper time; its compliment represents the fractional volumetric mismatch
(Criss and Winston, 2008).
}
\examples{
GOF_volumetric_efficiency(
  mod = example_mod$streamflow_cfs, obs = example_obs$streamflow_cfs
)

}
\references{
Criss, R.E. and Winston, W.E., 2008, Do Nash values have value? Discussion and alternate
proposals: Hydrological Processes, v. 22, p. 2723-2725.\cr
[Also available at https://doi.org/10.1002/hyp.7072.]

Zambrano-Bigiarini, M., 2020, hydroGOF: Goodness-of-fit functions for comparison of simulated
and observed hydrological time series R package version 0.4-0.
accessed September 16, 2020, at https://github.com/hzambran/hydroGOF.
[Also available at https://doi.org/10.5281/zenodo.839854.]
}
\keyword{goodness-of-fit}
