% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{GOF_correlation_tests}
\alias{GOF_correlation_tests}
\title{Calculates Kendall's Tau, Spearman's Rho, Pearson Correlation}
\usage{
GOF_correlation_tests(mod, obs, na.rm = TRUE, ...)
}
\arguments{
\item{mod}{'numeric' vector. Modeled or simulated values. Must be same length as \code{obs}.}

\item{obs}{'numeric' vector. Observed or comparison values. Must be same length as \code{mod}.}

\item{na.rm}{'boolean' \code{TRUE} or \code{FALSE}. Should \code{NA} values be removed before computing. If any
\code{NA} values are present in \code{mod} or \code{obs}, the \emph{i}th position from each will be removed before
calculating. If \code{NA} values are present and \code{na.rm = FALSE}, then function will return \code{NA}.
Default is \code{TRUE}}

\item{...}{Further arguments to be passed to or from \code{\link[stats:cor.test]{stats::cor.test}}.}
}
\value{
A tibble (\code{\link[tibble:tibble]{tibble::tibble}}) with test statistic values and p-values.
}
\description{
Calculates Kendall's Tau, Spearman's Rho, Pearson Correlation, and p-values
as a wrapper to the \code{\link[stats:cor.test]{stats::cor.test}} function. Output is tidy-style data.frame.
}
\details{
See \code{\link[stats:cor.test]{stats::cor.test}} for more details and further arguments to be passed to or from methods.
Defaults are used.
}
\examples{
GOF_correlation_tests(mod = example_mod$streamflow_cfs, obs = example_obs$streamflow_cfs)

}
\seealso{
\code{\link[stats]{cor.test}}
}
\keyword{goodness-of-fit}
