\name{HistData-package}
\Rdversion{1.1}
\alias{HistData-package}
\alias{HistData}
\docType{package}
\title{
Data sets from the history of statistics and data visualization}

\description{
The HistData package provides a collection of data sets
that are interesting and important in the history of statistics and data visualization.
The goal of the package is to make these available, both for instructional use
and for historical research.

}
\details{
\tabular{ll}{
Package: \tab HistData\cr
Type: \tab Package\cr
Version: \tab 0.6-7\cr
Date: \tab 2010-02-28\cr
License: \tab GPL\cr
LazyLoad: \tab yes\cr
LazyData: \tab yes\cr
}
Some of the data sets have examples which reproduce an historical graph or analysis.
These are meant mainly as starters for more extensive re-analysis or graphical
elaboration. Some of these present graphical challenges to reproduce in R.
}
\author{
Michael Friendly

Maintainer: Michael Friendly <friendly@yorku.ca>
}
\references{
Friendly, M. (2007). A Brief History of Data Visualization.
In Chen, C., Hardle, W. & Unwin, A. (eds.)  
\emph{Handbook of Computational Statistics: Data Visualization}, Springer-Verlag, III, Ch. 1, 1-34.

Friendly, M. & Denis, D. (2001).
Milestones in the history of thematic cartography, statistical graphics, and data visualization.
\url{http://datavis.ca/milestones/}

Friendly, M. & Denis, D. (2005). The early origins and development of the scatterplot. 
\emph{Journal of the History of the Behavioral Sciences}, 
41, 103-130.

}
\seealso{
Other packages containing data sets of historical interest include:

The \code{\link[Guerry]{Guerry-package}}, containing maps and
other data sets related to Guerry's (1833) \emph{Moral Statistics of France}.

\code{\link[xgobi]{morsecodes}} from the \pkg{xgobi} package
for data from Rothkopf (1957) on errors in learning morse code, a classical
example for MDS.

The \pkg{psych} package, containing Galton's \code{\link[psych]{peas}} data.
The same data set is contained in \pkg{alr3} as \code{\link[alr3]{galtonpeas}}.
}

\keyword{ package }
%\seealso{
%~~ Optional links to other man pages, e.g. ~~
%~~ \code{\link[<pkg>:<pkg>-package]{<pkg>}} ~~
%}
\examples{
# see examples for the separate data sets
}
