% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/harmonic.regression.R
\name{rna.polya}
\alias{rna.polya}
\title{Menet et al. RNA-Seq Data}
\format{a data frame with poly(A)+ RNA-seq data}
\source{
Jerome S Menet, Joseph Rodriguez, Katharine C Abruzzi, Michael
  Rosbash. Nascent-Seq reveals novel features of mouse circadian
  transcriptional regulation. eLife 1:e00011 (2012).
}
\description{
Quantification of circadian transcriptional activity in mouse liver.
}
\details{
The poly(A)+-seq data represent mature mRNA abundances.
  Raw data was collected from the supplementary material of the original
  publication cited below. In that study, samples were collected at 6
  different times of day in two biological replicates (fields ZT* in the data
  frame). The field 'mgi_symbol' refers to MGI gene names.
}
\examples{
data(rna.polya)
polya.t <- seq(0, 44, 4)
plot(polya.t, rna.polya["Arntl", -1], type="b")
}

