% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showGen.R
\name{showGen}
\alias{showGen}
\title{Display chosen genotypes}
\usage{
showGen(data.in, design = "triad", n = 5, from, to, sex, markers = 1:5)
}
\arguments{
\item{data.in}{The data read in by \link{genDataRead}.}

\item{design}{The design used in the study - choose from:
\itemize{
  \item \emph{triad} - data includes genotypes of mother, father and child;
  \item \emph{cc} - classical case-control;
  \item \emph{cc.triad} - hybrid design: triads with cases and controls;
}.}

\item{n}{Number of rows to display or "all" (default: 5).}

\item{from}{From which row to display (optional, default: from the first).}

\item{to}{To which row to display (optional).}

\item{sex}{If the sex column is part of the phenotypic information, the user can
choose based on one of the categories used in this column (optional);
NB: this does not combine with the 'to' and 'from' arguments.}

\item{markers}{A vector specifying which markers to display or "all" (default: first
5); NB: the user can specify the markers by numbers or by their names.}
}
\value{
A table with genotypes extracted from 'data.in'.
}
\description{
This is a help function to extract genotypes from an object read in with
 \link{genDataRead} (or loaded with \link{genDataLoad}).
}
