% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f.convert.matrix.ff.R
\name{f.convert.matrix.ff}
\alias{f.convert.matrix.ff}
\title{Converting Haplin-formatted matrix into the new format}
\usage{
f.convert.matrix.ff(data = stop("You must give the data to convert!", call. =
  FALSE),
  n.vars = stop("You must explicitly give the number of columns with covariates!",
  call. = FALSE), cov.header, gen.levels)
}
\arguments{
\item{data}{A character matrix (NB: it's assumed that this matrix contains genotypes
and covariate data, if any; i.e., as if it was a table read in from a haplin-formatted
file).}

\item{n.vars}{Number of columns with covariate variables - if the data does not contain
covariates, give 0 explicitly.}

\item{cov.header}{Optional; if there are covariates in the data, you can give their 
names explicitly here. Otherwise, dummy names will be created.}

\item{gen.levels}{Optional; a vector with all the possible values for alleles in the
genotype part of data. If not given, these will be assessed from the given data.}
}
\value{
A list object with two elements:
  \itemize{
    \item \emph{cov.data} - a \code{data.frame} with covariate data (if available in
       the input file)
    \item \emph{gen.data} - a list with chunks of the genetic data; the data is divided
       column-wise, using 10,000 columns per chunk; each element of this list is a
       \link[ff]{ff} matrix
  }
}
\description{
Internal function for converting an R matrix object into the new format of data used in Haplin. The output is the same as from \link{genDataRead}.
}
