% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_Harmonized.R
\name{WriteHarmonizedData}
\alias{WriteHarmonizedData}
\title{Write a Harmonized Data File}
\usage{
WriteHarmonizedData(
  df,
  filename = "",
  replace.accents = FALSE,
  strip.punctuation = FALSE,
  ignore.cols = NULL,
  nThread = NULL
)
}
\arguments{
\item{df}{Data frame containing the harmonized data.}

\item{filename}{Path to and file name (including ".csv" file extension) of the Harmonized Data CSV file to export. Windows users: Note that
Paths are separated by '/', not '\\'.}

\item{replace.accents}{Logical, if \code{TRUE}, then accented characters (e.g. ä, ö, å) will be replaced with non-accented characters in all strings.
If \code{FALSE}, then strings will be left unmodified.}

\item{strip.punctuation}{Logical, if \code{TRUE}, then punctuation characters (e.g. "-", ".", ".") will be removed from all strings.
If \code{FALSE}, then strings will be left unmodified.}

\item{ignore.cols}{Vector of columns in \code{df} that should be ignored when \code{replace.accents} or \code{strip.punctuation} are set to \code{TRUE}.}

\item{nThread}{Integer, set number of threads to be used when writing file. If \code{NULL} (default), then the output of \link[data.table:openmp-utils]{data.table::getDTthreads} will be used.}
}
\value{
\code{WriteHarmonizedData} exports a CSV file if \code{filename} is specified. Otherwise, the function outputs a data frame to the console.
}
\description{
This is a convenience wrapper function to export a data frame to the required Harmonized Data File format. See the
\href{https://git.smhi.se/fouh/hypeobsmetadatatools}{HYPEObsMetadataTools documentation}.
}
\details{
\code{WriteHarmonizedData} is a convenience wrapper function of \code{\link[data.table]{fread}} to export harmonized data in the HYPEObsMetadataTools Harmonized Data Format.
The function checks that all required columns are present, includes options to format strings, and exports data to output CSV files with the correct encoding and formatting.
}
\examples{
df <- data.frame(
  "STATION_ID" = "A1",
  "DATE_START" = "2002-06-18 12:00",
  "DATE_END" = "2002-06-18 12:00",
  "PARAMETER" = "NH4_N",
  "VALUE" = 0.050,
  "UNIT" = "mg/L",
  "QUALITY_CODE" = "AA"
)
WriteHarmonizedData(df)

}
