% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_VisualizeMapOutput.R
\name{VisualizeMapOutput}
\alias{VisualizeMapOutput}
\alias{VisualiseMapOutput}
\title{Shiny App for visualizing HYPE MapOutputs.}
\usage{
VisualizeMapOutput(
  results.dir = NULL,
  file.pattern = "^map.*\\\\.(txt|csv)$",
  map = NULL,
  map.subid.column = 1,
  output.dir = NULL
)

VisualiseMapOutput(
  results.dir = NULL,
  file.pattern = "^map.*\\\\.(txt|csv)$",
  map = NULL,
  map.subid.column = 1,
  output.dir = NULL
)
}
\arguments{
\item{results.dir}{Optional string, path to a directory containing MapOutput files that should be loaded on app initialization.}

\item{file.pattern}{Optional string, filename pattern to select files in \code{results.dir} that should be loaded on app initialization. See \code{\link{list.files}}.}

\item{map}{Optional string, path to GIS file for subbasin polygons that should be loaded on app initialization. Typically a GeoPackage (.gpkg) or Shapefile (.shp).}

\item{map.subid.column}{Optional integer, column index in the \code{map} 'data' \code{\link{slot}} holding SUBIDs (sub-catchment IDs) that should be used on app initialization.}

\item{output.dir}{Optional string, path to a default output directory to save captured map images.}
}
\value{
\code{VisualizeMapOutput} returns a Shiny application object.
}
\description{
Interactive maps and plots for visualizing MapOutput files.
}
\details{
\code{VisualizeMapOutput} is a Shiny app that provides interactive maps, plots, and tables for visualizing HYPE MapOutput files. The interactive Leaflet map is generated using \code{\link{PlotMapOutput}}.
The app can be launched with or without the input arguments. All necessary input buttons and menus are provided within the app interface. For convenience, however, the input arguments can be provided in order to quickly launch the
app with desired settings.
}
\examples{
\dontrun{
if (interactive()) {
  VisualizeMapOutput(
    results.dir = system.file("demo_model", "results", package = "HYPEtools"),
    map = system.file("demo_model", "gis", "Nytorp_map.gpkg", package = "HYPEtools"),
    map.subid.column = 25
  )
}
}

}
\seealso{
\code{\link{ReadMapOutput}}; \code{\link{PlotMapOutput}}
}
